/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadableDetachableModel<T>
implements IModel<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LoadableDetachableModel.class);
    private transient InternalState state = InternalState.DETACHED;
    private transient T transientModelObject;

    public LoadableDetachableModel() {
    }

    public LoadableDetachableModel(T object) {
        this.transientModelObject = object;
        this.state = InternalState.ATTACHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        if (this.state != null && this.state != InternalState.DETACHED) {
            try {
                this.onDetach();
            }
            finally {
                this.state = InternalState.DETACHED;
                this.transientModelObject = null;
                log.debug("removed transient object for {}, requestCycle {}", (Object)this, (Object)RequestCycle.get());
            }
        }
    }

    @Override
    public final T getObject() {
        if (this.state == null || this.state == InternalState.DETACHED) {
            this.state = InternalState.ATTACHING;
            this.transientModelObject = this.load();
            if (log.isDebugEnabled()) {
                log.debug("loaded transient object " + this.transientModelObject + " for " + this + ", requestCycle " + RequestCycle.get());
            }
            this.state = InternalState.ATTACHED;
            this.onAttach();
        }
        return this.transientModelObject;
    }

    public final boolean isAttached() {
        return this.state == InternalState.ATTACHED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":attached=").append(this.isAttached()).append(":tempModelObject=[").append(this.transientModelObject).append("]");
        return sb.toString();
    }

    protected abstract T load();

    protected void onAttach() {
    }

    protected void onDetach() {
    }

    @Override
    public void setObject(T object) {
        this.state = InternalState.ATTACHED;
        this.transientModelObject = object;
    }

    private static enum InternalState {
        DETACHED,
        ATTACHING,
        ATTACHED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

