/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.core.request.handler.BookmarkableListenerInterfaceRequestHandler;
import org.apache.wicket.core.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.ListenerInterfaceRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.mapper.AbstractComponentMapper;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.ComponentInfo;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.info.PageInfo;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBookmarkableMapper
extends AbstractComponentMapper {
    private static Logger logger = LoggerFactory.getLogger(AbstractBookmarkableMapper.class);
    private boolean isCaseSensitive = true;
    protected final List<MountPathSegment> pathSegments;
    protected final String[] mountSegments;
    protected final IPageParametersEncoder pageParametersEncoder;

    public AbstractBookmarkableMapper() {
        this("notUsed", (IPageParametersEncoder)new PageParametersEncoder());
    }

    public AbstractBookmarkableMapper(String mountPath, IPageParametersEncoder pageParametersEncoder) {
        Args.notEmpty((CharSequence)mountPath, (String)"mountPath");
        this.pageParametersEncoder = (IPageParametersEncoder)Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.mountSegments = this.getMountSegments(mountPath);
        this.pathSegments = this.getPathSegments(this.mountSegments);
    }

    protected abstract UrlInfo parseRequest(Request var1);

    protected abstract Url buildUrl(UrlInfo var1);

    protected abstract boolean pageMustHaveBeenCreatedBookmarkable();

    public int getCompatibilityScore(Request request) {
        if (this.urlStartsWith(request.getUrl(), this.mountSegments)) {
            int countOptional = 0;
            int fixedSegments = 0;
            for (MountPathSegment pathSegment : this.pathSegments) {
                fixedSegments += pathSegment.getFixedPartSize();
                countOptional += pathSegment.getOptionalParameters();
            }
            return this.mountSegments.length - countOptional + fixedSegments;
        }
        return 0;
    }

    protected IRequestHandler processBookmarkable(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        PageProvider provider = new PageProvider(pageClass, pageParameters);
        provider.setPageSource(this.getContext());
        return new RenderPageRequestHandler(provider);
    }

    protected IRequestHandler processHybrid(PageInfo pageInfo, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        PageParameters constructionPageParameters;
        PageProvider provider = new PageProvider(pageInfo.getPageId(), pageClass, pageParameters, renderCount);
        provider.setPageSource(this.getContext());
        this.checkExpiration(provider, pageInfo);
        PageParameters pageParameters2 = constructionPageParameters = provider.hasPageInstance() ? provider.getPageInstance().getPageParameters() : new PageParameters();
        if (!PageParameters.equals((PageParameters)constructionPageParameters, (PageParameters)pageParameters)) {
            return new RenderPageRequestHandler(new PageProvider(pageClass, pageParameters));
        }
        return new RenderPageRequestHandler(provider);
    }

    boolean getRecreateMountedPagesAfterExpiry() {
        return WebApplication.get().getPageSettings().getRecreateBookmarkablePagesAfterExpiry();
    }

    protected IRequestHandler processListener(PageComponentInfo pageComponentInfo, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        PageInfo pageInfo = pageComponentInfo.getPageInfo();
        ComponentInfo componentInfo = pageComponentInfo.getComponentInfo();
        Integer renderCount = null;
        RequestListenerInterface listenerInterface = null;
        if (componentInfo != null) {
            renderCount = componentInfo.getRenderCount();
            listenerInterface = this.requestListenerInterfaceFromString(componentInfo.getListenerInterface());
        }
        if (listenerInterface != null) {
            PageAndComponentProvider provider = new PageAndComponentProvider(pageInfo.getPageId(), pageClass, pageParameters, renderCount, componentInfo.getComponentPath());
            provider.setPageSource(this.getContext());
            this.checkExpiration(provider, pageInfo);
            return new ListenerInterfaceRequestHandler(provider, listenerInterface, componentInfo.getBehaviorId());
        }
        if (logger.isWarnEnabled()) {
            if (componentInfo != null) {
                logger.warn("Unknown listener interface '{}'", (Object)componentInfo.getListenerInterface());
            } else {
                logger.warn("Cannot extract the listener interface for PageComponentInfo: '{}'" + pageComponentInfo);
            }
        }
        return null;
    }

    private void checkExpiration(PageProvider provider, PageInfo pageInfo) {
        if (provider.getPageId() != null && provider.isNewPageInstance() && !this.getRecreateMountedPagesAfterExpiry()) {
            throw new PageExpiredException(String.format("Bookmarkable page with id '%d' has expired.", pageInfo.getPageId()));
        }
    }

    public IRequestHandler mapRequest(Request request) {
        UrlInfo urlInfo = this.parseRequest(request);
        if (urlInfo != null) {
            PageComponentInfo info = urlInfo.getPageComponentInfo();
            Class<? extends IRequestablePage> pageClass = urlInfo.getPageClass();
            PageParameters pageParameters = urlInfo.getPageParameters();
            if (info == null) {
                return this.processBookmarkable(pageClass, pageParameters);
            }
            if (info.getPageInfo().getPageId() != null && info.getComponentInfo() == null) {
                return this.processHybrid(info.getPageInfo(), pageClass, pageParameters, null);
            }
            if (info.getComponentInfo() != null) {
                return this.processListener(info, pageClass, pageParameters);
            }
            if (info.getPageInfo().getPageId() == null) {
                return this.processBookmarkable(pageClass, pageParameters);
            }
        }
        return null;
    }

    protected boolean checkPageInstance(IRequestablePage page) {
        return page != null && this.checkPageClass(page.getClass());
    }

    protected boolean checkPageClass(Class<? extends IRequestablePage> pageClass) {
        return true;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        while (requestHandler instanceof IRequestHandlerDelegate) {
            requestHandler = ((IRequestHandlerDelegate)requestHandler).getDelegateHandler();
        }
        if (requestHandler instanceof BookmarkablePageRequestHandler) {
            BookmarkablePageRequestHandler handler = (BookmarkablePageRequestHandler)requestHandler;
            if (!this.checkPageClass(handler.getPageClass())) {
                return null;
            }
            PageInfo info = new PageInfo();
            UrlInfo urlInfo = new UrlInfo(new PageComponentInfo(info, null), handler.getPageClass(), handler.getPageParameters());
            return this.buildUrl(urlInfo);
        }
        if (requestHandler instanceof RenderPageRequestHandler) {
            RenderPageRequestHandler handler = (RenderPageRequestHandler)requestHandler;
            if (!this.checkPageClass(handler.getPageClass())) {
                return null;
            }
            if (handler.getPageProvider().isNewPageInstance()) {
                PageInfo info = new PageInfo();
                UrlInfo urlInfo = new UrlInfo(new PageComponentInfo(info, null), handler.getPageClass(), handler.getPageParameters());
                return this.buildUrl(urlInfo);
            }
            IRequestablePage page = handler.getPage();
            if (this.checkPageInstance(page) && (!this.pageMustHaveBeenCreatedBookmarkable() || page.wasCreatedBookmarkable())) {
                PageInfo info = this.getPageInfo(handler);
                PageComponentInfo pageComponentInfo = new PageComponentInfo(info, null);
                UrlInfo urlInfo = new UrlInfo(pageComponentInfo, page.getClass(), handler.getPageParameters());
                return this.buildUrl(urlInfo);
            }
            return null;
        }
        if (requestHandler instanceof BookmarkableListenerInterfaceRequestHandler) {
            BookmarkableListenerInterfaceRequestHandler handler = (BookmarkableListenerInterfaceRequestHandler)requestHandler;
            Class<? extends IRequestablePage> pageClass = handler.getPageClass();
            if (!this.checkPageClass(pageClass)) {
                return null;
            }
            Integer renderCount = null;
            if (handler.getListenerInterface().isIncludeRenderCount()) {
                renderCount = handler.getRenderCount();
            }
            PageInfo pageInfo = this.getPageInfo(handler);
            ComponentInfo componentInfo = new ComponentInfo(renderCount, this.requestListenerInterfaceToString(handler.getListenerInterface()), handler.getComponentPath(), handler.getBehaviorIndex());
            PageParameters parameters = this.getRecreateMountedPagesAfterExpiry() ? new PageParameters(handler.getPage().getPageParameters()).mergeWith(handler.getPageParameters()) : handler.getPageParameters();
            UrlInfo urlInfo = new UrlInfo(new PageComponentInfo(pageInfo, componentInfo), pageClass, parameters);
            return this.buildUrl(urlInfo);
        }
        return null;
    }

    protected final PageInfo getPageInfo(IPageRequestHandler handler) {
        IRequestablePage page;
        Args.notNull((Object)handler, (String)"handler");
        Integer pageId = null;
        if (handler.isPageInstanceCreated() && !(page = handler.getPage()).isPageStateless()) {
            pageId = page.getPageId();
        }
        return new PageInfo(pageId);
    }

    protected List<MountPathSegment> getPathSegments(String[] segments) {
        ArrayList<MountPathSegment> ret = new ArrayList<MountPathSegment>();
        int segmentIndex = 0;
        MountPathSegment curPathSegment = new MountPathSegment(segmentIndex);
        ret.add(curPathSegment);
        for (String curSegment : segments) {
            if (this.isFixedSegment(curSegment)) {
                curPathSegment.setFixedPart(curSegment);
                curPathSegment = new MountPathSegment(segmentIndex + 1);
                ret.add(curPathSegment);
            } else if (this.getPlaceholder(curSegment) != null) {
                curPathSegment.addRequiredParameter();
            } else {
                curPathSegment.addOptionalParameter();
            }
            ++segmentIndex;
        }
        return ret;
    }

    protected boolean isFixedSegment(String segment) {
        return this.getOptionalPlaceholder(segment) == null && this.getPlaceholder(segment) == null;
    }

    protected PageParameters extractPageParameters(Request request, Url url) {
        int[] matchedParameters = this.getMatchedSegmentSizes(url);
        int total = 0;
        for (int curMatchSize : matchedParameters) {
            total += curMatchSize;
        }
        PageParameters pageParameters = this.extractPageParameters(request, total, this.pageParametersEncoder);
        int skippedParameters = 0;
        for (int pathSegmentIndex = 0; pathSegmentIndex < this.pathSegments.size(); ++pathSegmentIndex) {
            MountPathSegment curPathSegment = this.pathSegments.get(pathSegmentIndex);
            int matchSize = matchedParameters[pathSegmentIndex] - curPathSegment.getFixedPartSize();
            int optionalParameterMatch = matchSize - curPathSegment.getMinParameters();
            for (int matchSegment = 0; matchSegment < matchSize; ++matchSegment) {
                if (pageParameters == null) {
                    pageParameters = new PageParameters();
                }
                int curSegmentIndex = matchSegment + curPathSegment.getSegmentIndex();
                String curSegment = this.mountSegments[curSegmentIndex];
                String placeholder = this.getPlaceholder(curSegment);
                String optionalPlaceholder = this.getOptionalPlaceholder(curSegment);
                if (placeholder != null) {
                    pageParameters.add(placeholder, url.getSegments().get(curSegmentIndex - skippedParameters), INamedParameters.Type.PATH);
                    continue;
                }
                if (optionalPlaceholder == null || optionalParameterMatch <= 0) continue;
                pageParameters.add(optionalPlaceholder, url.getSegments().get(curSegmentIndex - skippedParameters), INamedParameters.Type.PATH);
                --optionalParameterMatch;
            }
            skippedParameters += curPathSegment.getMaxParameters() - matchSize;
        }
        return pageParameters;
    }

    protected int[] getMatchedSegmentSizes(Url url) {
        int[] ret = new int[this.pathSegments.size()];
        int segmentIndex = 0;
        int pathSegmentIndex = 0;
        for (MountPathSegment curPathSegment : this.pathSegments.subList(0, this.pathSegments.size() - 1)) {
            boolean foundFixedPart = false;
            int max = Math.min(curPathSegment.getOptionalParameters() + 1, url.getSegments().size() - (segmentIndex += curPathSegment.getMinParameters()));
            for (int count = max - 1; count >= 0; --count) {
                if (!this.segmentsMatch((String)url.getSegments().get(segmentIndex + count), curPathSegment.getFixedPart())) continue;
                foundFixedPart = true;
                segmentIndex += count + 1;
                ret[pathSegmentIndex] = count + curPathSegment.getMinParameters() + 1;
                break;
            }
            if (!foundFixedPart) {
                return null;
            }
            ++pathSegmentIndex;
        }
        MountPathSegment lastSegment = this.pathSegments.get(this.pathSegments.size() - 1);
        if ((segmentIndex += lastSegment.getMinParameters()) > url.getSegments().size()) {
            return null;
        }
        ret[pathSegmentIndex] = Math.min(lastSegment.getMaxParameters(), url.getSegments().size() - segmentIndex + lastSegment.getMinParameters());
        return ret;
    }

    protected boolean segmentsMatch(String mountedSegment, String urlSegment) {
        boolean result = this.isCaseSensitiveMatch() ? mountedSegment.equals(urlSegment) : mountedSegment.equalsIgnoreCase(urlSegment);
        return result;
    }

    protected boolean isCaseSensitiveMatch() {
        return this.isCaseSensitive;
    }

    public AbstractBookmarkableMapper setCaseSensitiveMatch(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        return this;
    }

    protected boolean setPlaceholders(PageParameters parameters, Url url) {
        boolean mandatoryParametersSet = true;
        int dropped = 0;
        for (int i = 0; i < this.mountSegments.length; ++i) {
            String placeholder = this.getPlaceholder(this.mountSegments[i]);
            String optionalPlaceholder = this.getOptionalPlaceholder(this.mountSegments[i]);
            if (placeholder != null) {
                if (parameters.getNamedKeys().contains(placeholder)) {
                    url.getSegments().set(i - dropped, parameters.get(placeholder).toString());
                    parameters.remove(placeholder, new String[0]);
                    continue;
                }
                mandatoryParametersSet = false;
                break;
            }
            if (optionalPlaceholder == null) continue;
            if (parameters.getNamedKeys().contains(optionalPlaceholder)) {
                url.getSegments().set(i - dropped, parameters.get(optionalPlaceholder).toString(""));
                parameters.remove(optionalPlaceholder, new String[0]);
                continue;
            }
            url.getSegments().remove(i - dropped);
            ++dropped;
        }
        return mandatoryParametersSet;
    }

    protected boolean urlStartsWithMountedSegments(Url url) {
        if (url == null) {
            return false;
        }
        return this.getMatchedSegmentSizes(url) != null;
    }

    protected static class MountPathSegment {
        private int segmentIndex;
        private String fixedPart;
        private int minParameters;
        private int optionalParameters;

        public MountPathSegment(int segmentIndex) {
            this.segmentIndex = segmentIndex;
        }

        public void setFixedPart(String fixedPart) {
            this.fixedPart = fixedPart;
        }

        public void addRequiredParameter() {
            ++this.minParameters;
        }

        public void addOptionalParameter() {
            ++this.optionalParameters;
        }

        public int getSegmentIndex() {
            return this.segmentIndex;
        }

        public String getFixedPart() {
            return this.fixedPart;
        }

        public int getMinParameters() {
            return this.minParameters;
        }

        public int getOptionalParameters() {
            return this.optionalParameters;
        }

        public int getMaxParameters() {
            return this.getOptionalParameters() + this.getMinParameters();
        }

        public int getFixedPartSize() {
            return this.getFixedPart() == null ? 0 : 1;
        }

        public String toString() {
            return "(" + this.getSegmentIndex() + ") " + this.getMinParameters() + '-' + this.getMaxParameters() + ' ' + (this.getFixedPart() == null ? "(end)" : this.getFixedPart());
        }
    }

    protected static final class UrlInfo {
        private final PageComponentInfo pageComponentInfo;
        private final PageParameters pageParameters;
        private final Class<? extends IRequestablePage> pageClass;

        public UrlInfo(PageComponentInfo pageComponentInfo, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
            Args.notNull(pageClass, (String)"pageClass");
            this.pageComponentInfo = pageComponentInfo;
            this.pageParameters = this.cleanPageParameters(pageParameters);
            this.pageClass = pageClass;
        }

        private PageParameters cleanPageParameters(PageParameters originalParameters) {
            PageParameters cleanParameters = null;
            if (originalParameters != null) {
                cleanParameters = new PageParameters(originalParameters);
                cleanParameters.remove("wicket-ajax", new String[0]);
                cleanParameters.remove("wicket-ajax-baseurl", new String[0]);
                cleanParameters.remove("_", new String[0]);
                if (cleanParameters.isEmpty()) {
                    cleanParameters = null;
                }
            }
            return cleanParameters;
        }

        public PageComponentInfo getPageComponentInfo() {
            return this.pageComponentInfo;
        }

        public Class<? extends IRequestablePage> getPageClass() {
            return this.pageClass;
        }

        public PageParameters getPageParameters() {
            return this.pageParameters;
        }
    }
}

