/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.progmodels.dflt;

import java.util.Collection;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaReflectorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JavaReflectorHelper.class);

    private JavaReflectorHelper() {
    }

    public static SpecificationLoader createObjectReflector(IsisConfiguration configuration, ProgrammingModel programmingModel, Collection<MetaModelRefiner> metaModelRefiners, List<LayoutMetadataReader> layoutMetadataReaders, MetaModelValidator mmv, ServicesInjector servicesInjector) {
        MetaModelValidatorComposite metaModelValidator = MetaModelValidatorComposite.asComposite(mmv);
        for (MetaModelRefiner metaModelRefiner : metaModelRefiners) {
            metaModelRefiner.refineProgrammingModel(programmingModel, configuration);
            metaModelRefiner.refineMetaModelValidator(metaModelValidator, configuration);
        }
        if (!metaModelRefiners.contains(programmingModel)) {
            programmingModel.refineMetaModelValidator(metaModelValidator, configuration);
        }
        return new SpecificationLoader(configuration, programmingModel, metaModelValidator, layoutMetadataReaders, servicesInjector);
    }
}

