/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.prop.column;

import java.util.List;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.property.maxlength.MaxLengthFacetForMaxLengthAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.maxlength.MaxLengthFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.MaxLengthFacetDerivedFromJdoColumn;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;
import org.datanucleus.enhancement.Persistable;

public class MaxLengthDerivedFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public MaxLengthDerivedFromJdoColumnAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> cls = processMethodContext.getCls();
        if (!Persistable.class.isAssignableFrom(cls)) {
            return;
        }
        Column annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Column.class);
        if (String.class != processMethodContext.getMethod().getReturnType()) {
            return;
        }
        if (annotation == null || annotation.length() == -1) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        MaxLengthFacet existingFacet = holder.getFacet(MaxLengthFacet.class);
        MaxLengthFacetDerivedFromJdoColumn facet = new MaxLengthFacetDerivedFromJdoColumn((Integer)annotation.length(), (FacetHolder)holder);
        if (!existingFacet.isNoop()) {
            facet.setUnderlyingFacet(existingFacet);
        }
        FacetUtil.addFacet(facet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    private MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                JdoPersistenceCapableFacet pcFacet = objectSpec.getFacet(JdoPersistenceCapableFacet.class);
                if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                    return;
                }
                List<ObjectAssociation> associations = objectSpec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES);
                for (ObjectAssociation association : associations) {
                    MaxLengthFacet facet;
                    MaxLengthFacet underlying;
                    if (association.containsDoOpFacet(JdoNotPersistentFacet.class) || (underlying = (MaxLengthFacet)(facet = association.getFacet(MaxLengthFacet.class)).getUnderlyingFacet()) == null) continue;
                    if (facet instanceof MaxLengthFacetDerivedFromJdoColumn && underlying instanceof MaxLengthFacetForMaxLengthAnnotationOnProperty && facet.value() != underlying.value()) {
                        validationFailures.add("%s: inconsistent lengths specified in Isis' @MaxLength(...) and @javax.jdo.annotations.Column(length=...); use just @javax.jdo.annotations.Column(length=...)", association.getIdentifier().toClassAndNameIdentityString());
                    }
                    if (!(facet instanceof MaxLengthFacetDerivedFromJdoColumn) || !(underlying instanceof MaxLengthFacetForPropertyAnnotation) || facet.value() == underlying.value()) continue;
                    validationFailures.add("%s: inconsistent lengths specified in Isis' @Property(maxLength=...) and @javax.jdo.annotations.Column(length=...); use just @javax.jdo.annotations.Column(length=...)", association.getIdentifier().toClassAndNameIdentityString());
                }
            }
        };
    }
}

