/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.prop.column;

import java.math.BigDecimal;
import java.util.List;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.properties.bigdecimal.javaxvaldigits.BigDecimalFacetOnPropertyFromJavaxValidationDigitsAnnotation;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.BigDecimalFacetDerivedFromJdoColumn;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.BigDecimalFacetFallback;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class BigDecimalDerivedFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private static final int DEFAULT_LENGTH = 18;
    private static final int DEFAULT_SCALE = 2;

    public BigDecimalDerivedFromJdoColumnAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        if (BigDecimal.class != processMethodContext.getMethod().getReturnType()) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        BigDecimalValueFacet existingFacet = holder.getFacet(BigDecimalValueFacet.class);
        Column jdoColumnAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Column.class);
        if (jdoColumnAnnotation == null) {
            if (existingFacet == null || existingFacet.isNoop()) {
                BigDecimalFacetFallback facet = new BigDecimalFacetFallback(holder);
                FacetUtil.addFacet(facet);
            }
        } else {
            Integer existingLength = null;
            Integer existingScale = null;
            if (existingFacet != null && !existingFacet.isNoop()) {
                existingLength = existingFacet.getLength();
                existingScale = existingFacet.getScale();
            }
            Integer length = BigDecimalDerivedFromJdoColumnAnnotationFacetFactory.valueElseDefaults(jdoColumnAnnotation.length(), existingLength, 18);
            Integer scale = BigDecimalDerivedFromJdoColumnAnnotationFacetFactory.valueElseDefaults(jdoColumnAnnotation.scale(), existingScale, 2);
            BigDecimalFacetDerivedFromJdoColumn facet = new BigDecimalFacetDerivedFromJdoColumn(holder, length, scale);
            FacetUtil.addFacet(facet);
        }
    }

    private static final Integer valueElseDefaults(int value, Integer underlying, int defaultVal) {
        return value != -1 ? value : (underlying != null ? underlying : defaultVal);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    private MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                JdoPersistenceCapableFacet pcFacet = objectSpec.getFacet(JdoPersistenceCapableFacet.class);
                if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                    return;
                }
                List<ObjectAssociation> associations = objectSpec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES);
                for (ObjectAssociation association : associations) {
                    if (association.containsDoOpFacet(JdoNotPersistentFacet.class)) continue;
                    this.validateBigDecimalValueFacet(association, validationFailures);
                }
            }

            private void validateBigDecimalValueFacet(ObjectAssociation association, ValidationFailures validationFailures) {
                BigDecimalValueFacet facet = association.getFacet(BigDecimalValueFacet.class);
                if (facet == null) {
                    return;
                }
                BigDecimalValueFacet underlying = (BigDecimalValueFacet)facet.getUnderlyingFacet();
                if (underlying == null) {
                    return;
                }
                if (facet instanceof BigDecimalFacetDerivedFromJdoColumn && underlying instanceof BigDecimalFacetOnPropertyFromJavaxValidationDigitsAnnotation) {
                    if (this.notNullButNotEqual(facet.getLength(), underlying.getLength())) {
                        validationFailures.add("%s: @javax.jdo.annotations.Column(length=...) different from @javax.validation.constraint.Digits(...); should equal the sum of its integer and fraction attributes", association.getIdentifier().toClassAndNameIdentityString());
                    }
                    if (this.notNullButNotEqual(facet.getScale(), underlying.getScale())) {
                        validationFailures.add("%s: @javax.jdo.annotations.Column(scale=...) different from @javax.validation.constraint.Digits(fraction=...)", association.getIdentifier().toClassAndNameIdentityString());
                    }
                }
            }

            private boolean notNullButNotEqual(Integer x, Integer y) {
                return x != null && y != null && !x.equals(y);
            }
        };
    }
}

