/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.version;

import javax.jdo.annotations.Version;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.version.JdoVersionFacetFromAnnotation;
import org.datanucleus.enhancement.Persistable;

public class JdoVersionAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public JdoVersionAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        if (!Persistable.class.isAssignableFrom(cls)) {
            return;
        }
        Version annotation = Annotations.getDeclaredAnnotation(cls, Version.class);
        if (annotation == null) {
            return;
        }
        FacetUtil.addFacet(new JdoVersionFacetFromAnnotation((FacetHolder)processClassContext.getFacetHolder()));
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                if (!this.declaresVersionAnnotation(objectSpec)) {
                    return;
                }
                for (ObjectSpecification superclassSpec = objectSpec.superclass(); superclassSpec != null; superclassSpec = superclassSpec.superclass()) {
                    if (!this.declaresVersionAnnotation(superclassSpec)) continue;
                    validationFailures.add("%s: cannot have @Version annotated on this subclass and any of its supertypes; superclass: %s", objectSpec.getFullIdentifier(), superclassSpec.getFullIdentifier());
                    return;
                }
            }

            private boolean declaresVersionAnnotation(ObjectSpecification objectSpec) {
                return Annotations.getDeclaredAnnotation(objectSpec.getCorrespondingClass(), Version.class) != null;
            }
        };
    }
}

