/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.discriminator;

import com.google.common.base.Strings;
import javax.jdo.annotations.Discriminator;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.ObjectSpecIdFacetFactory;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.objectspecid.classname.ObjectSpecIdFacetDerivedFromClassName;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.discriminator.JdoDiscriminatorFacetDefault;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.discriminator.ObjectSpecIdFacetInferredFromJdoDiscriminatorValueAnnotation;
import org.datanucleus.enhancement.Persistable;

public class JdoDiscriminatorAnnotationFacetFactory
extends FacetFactoryAbstract
implements ObjectSpecIdFacetFactory {
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();

    public JdoDiscriminatorAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(ObjectSpecIdFacetFactory.ProcessObjectSpecIdContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        if (!Persistable.class.isAssignableFrom(cls)) {
            return;
        }
        Discriminator annotation = Annotations.getAnnotation(cls, Discriminator.class);
        if (annotation == null) {
            return;
        }
        Object facetHolder = processClassContext.getFacetHolder();
        String annotationValue = annotation.value();
        ObjectSpecIdFacetAbstract facet = !Strings.isNullOrEmpty((String)annotationValue) ? new ObjectSpecIdFacetInferredFromJdoDiscriminatorValueAnnotation(annotationValue, (FacetHolder)facetHolder) : new ObjectSpecIdFacetDerivedFromClassName(this.classSubstitutor.getClass(cls).getCanonicalName(), (FacetHolder)facetHolder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        if (!Persistable.class.isAssignableFrom(cls)) {
            return;
        }
        Object facetHolder = processClassContext.getFacetHolder();
        Discriminator annotation = Annotations.getAnnotation(cls, Discriminator.class);
        if (annotation == null) {
            return;
        }
        String annotationValueAttribute = annotation.value();
        FacetUtil.addFacet(new JdoDiscriminatorFacetDefault(annotationValueAttribute, (FacetHolder)facetHolder));
    }
}

