/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.content;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.isis.core.commons.lang.InputStreamExtensions;
import org.apache.isis.core.commons.lang.ResourceUtil;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = StringExtensions.stripLeadingSlash(request.getServletPath());
        LOG.debug("request: {}", (Object)servletPath);
        FileInputStream is2 = this.getRealPath(request);
        if (is2 != null) {
            LOG.debug("request: {} loaded from filesystem", (Object)servletPath);
            ResourceServlet.writeContentType(request, response);
            InputStreamExtensions.copyTo(is2, (OutputStream)response.getOutputStream());
            ((InputStream)is2).close();
            return;
        }
        InputStream is = ResourceUtil.getResourceAsStream(servletPath);
        if (is != null) {
            LOG.debug("request: {} loaded from classpath", (Object)servletPath);
            ResourceServlet.writeContentType(request, response);
            InputStreamExtensions.copyTo(is, (OutputStream)response.getOutputStream());
            is.close();
            return;
        }
        LOG.warn("failed to load resource from classpath or file system: {}", (Object)servletPath);
    }

    private static void writeContentType(HttpServletRequest request, HttpServletResponse response) {
        String contentType = ResourceServlet.guessContentType(request.getServletPath());
        if (contentType != null) {
            response.setContentType(contentType);
        }
    }

    private static String guessContentType(String servletPath) {
        if (servletPath.endsWith(".css")) {
            return "text/css";
        }
        if (servletPath.endsWith(".png")) {
            return "image/png";
        }
        if (servletPath.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (servletPath.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (servletPath.endsWith(".gif")) {
            return "image/gif";
        }
        if (servletPath.endsWith(".svg")) {
            return "image/svg+xml";
        }
        if (servletPath.endsWith(".js")) {
            return "application/x-javascript";
        }
        if (servletPath.endsWith(".html")) {
            return "text/html";
        }
        if (servletPath.endsWith(".swf")) {
            return "application/x-shockwave-flash";
        }
        return null;
    }

    private FileInputStream getRealPath(HttpServletRequest request) {
        String realPath = request.getSession().getServletContext().getRealPath(request.getServletPath());
        if (realPath == null) {
            return null;
        }
        try {
            return new FileInputStream(realPath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

