/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.threadpool;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolSupport.class);
    private static final int KEEP_ALIVE_TIME_SECS = 5;
    private static final int QUEUE_CAPACITY = 5000;
    private static final int MIN_CORE_POOL_SIZE = 4;
    private static final int MIN_MAX_POOL_SIZE = 4;
    private final ThreadGroup group = new ThreadGroup(ThreadPoolSupport.class.getName());
    private final ThreadPoolExecutor concurrentExecutor;
    private final ThreadPoolExecutor sequentialExecutor;
    private static ThreadPoolSupport threadPoolSupport;

    public static synchronized ThreadPoolSupport getInstance() {
        if (threadPoolSupport == null) {
            threadPoolSupport = new ThreadPoolSupport();
        }
        return threadPoolSupport;
    }

    private ThreadPoolSupport() {
        int corePoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 4);
        int maximumPoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 4);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(ThreadPoolSupport.this.group, r);
            }
        };
        Supplier<BlockingQueue<Runnable>> workQueueFactory = new Supplier<BlockingQueue<Runnable>>(){

            public BlockingQueue<Runnable> get() {
                return new LinkedBlockingQueue<Runnable>(5000);
            }
        };
        this.concurrentExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 5L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((BlockingQueue)workQueueFactory.get()), threadFactory);
        this.sequentialExecutor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((BlockingQueue)workQueueFactory.get()), threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        try {
            this.concurrentExecutor.shutdown();
        }
        finally {
            this.sequentialExecutor.shutdown();
        }
    }

    public List<Future<Object>> invokeAll(@Nullable List<Callable<Object>> callables) {
        return this.invokeAll(this.concurrentExecutor, callables);
    }

    public List<Future<Object>> invokeAll(Callable<Object> ... callables) {
        return this.invokeAll(Arrays.asList(callables));
    }

    public List<Future<Object>> invokeAllSequential(@Nullable List<Callable<Object>> callables) {
        return this.invokeAll(this.sequentialExecutor, callables);
    }

    public List<Future<Object>> invokeAllSequential(Callable<Object> ... callables) {
        return this.invokeAllSequential(Arrays.asList(callables));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> join(List<Future<Object>> futures) {
        if (futures == null) {
            return null;
        }
        long t0 = System.currentTimeMillis();
        try {
            ArrayList returnValues = Lists.newArrayList();
            for (Future<Object> future : futures) {
                Object result;
                try {
                    result = future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    result = null;
                }
                returnValues.add(result);
            }
            ArrayList arrayList = returnValues;
            return arrayList;
        }
        finally {
            long t1 = System.currentTimeMillis();
            if (LOG.isInfoEnabled()) {
                LOG.info("join'ing {} tasks: waited {} milliseconds ", (Object)futures.size(), (Object)(t1 - t0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> joinGatherFailures(List<Future<Object>> futures) {
        if (futures == null) {
            return null;
        }
        long t0 = System.currentTimeMillis();
        try {
            ArrayList returnValues = Lists.newArrayList();
            for (Future<Object> future : futures) {
                Object result;
                try {
                    result = future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
                returnValues.add(result);
            }
            ArrayList arrayList = returnValues;
            return arrayList;
        }
        finally {
            long t1 = System.currentTimeMillis();
            LOG.info("join'ing {} tasks: waited {} milliseconds ", (Object)futures.size(), (Object)(t1 - t0));
        }
    }

    public Object join(Future<Object> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    private List<Future<Object>> invokeAll(ThreadPoolExecutor executor, @Nullable List<Callable<Object>> callables) {
        if (ThreadPoolSupport.isEmpty(callables)) {
            return Collections.emptyList();
        }
        try {
            return executor.invokeAll(ThreadPoolSupport.timed(executor, callables));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Callable<Object>> timed(final ThreadPoolExecutor executor, List<Callable<Object>> callables) {
        final long queuedAt = System.currentTimeMillis();
        return FluentIterable.from(callables).transform((Function)new Function<Callable<Object>, Callable<Object>>(){

            public Callable<Object> apply(Callable<Object> callable) {
                int queueSize = executor.getQueue().size();
                return ThreadPoolSupport.timed(callable, queueSize, queuedAt);
            }
        }).toList();
    }

    private static Callable<Object> timed(final Callable<Object> callable, final int queueSize, final long queuedAt) {
        return new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                long startedAt = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("START: workQueue.size: {}, waited for: {}ms, {}", new Object[]{queueSize, startedAt - queuedAt, callable.toString()});
                }
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    long completedAt = System.currentTimeMillis();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("END: completed in: {}ms, {}", (Object)(completedAt - startedAt), (Object)callable.toString());
                    }
                }
            }
        };
    }

    private static boolean isEmpty(Collection<?> x) {
        return x == null || x.size() == 0;
    }
}

