/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authorization.standard;

import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.authorization.standard.AuthorizationFacet;

public abstract class AuthorizationFacetAbstract
extends FacetAbstract
implements AuthorizationFacet {
    private final AuthorizationManager authorizationManager;
    private final AuthenticationSessionProvider authenticationSessionProvider;

    public static Class<? extends Facet> type() {
        return AuthorizationFacet.class;
    }

    public AuthorizationFacetAbstract(FacetHolder holder, AuthorizationManager authorizationManager, AuthenticationSessionProvider authenticationSessionProvider) {
        super(AuthorizationFacetAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.authorizationManager = authorizationManager;
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        return this.authorizationManager.isVisible(this.getAuthenticationSession(), ic.getTarget(), ic.getIdentifier()) ? null : "Not authorized to view";
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        return this.authorizationManager.isUsable(this.getAuthenticationSession(), ic.getTarget(), ic.getIdentifier()) ? null : "Not authorized to edit";
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }
}

