/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authentication.exploration;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.exploration.AuthenticationRequestExploration;
import org.apache.isis.core.runtime.authentication.exploration.ExplorationSession;
import org.apache.isis.core.runtime.authentication.standard.AuthenticatorAbstract;
import org.apache.isis.core.runtime.authentication.standard.SimpleSession;

public class ExplorationAuthenticator
extends AuthenticatorAbstract {
    private final Set<SimpleSession> registeredSessions = new LinkedHashSet<SimpleSession>();
    private final String users = this.getConfiguration().getString("isis.exploration.users");

    public ExplorationAuthenticator(IsisConfiguration configuration) {
        super(configuration);
        if (this.users != null) {
            this.registeredSessions.addAll(this.parseUsers(this.users));
        }
    }

    private List<SimpleSession> parseUsers(String users) {
        ArrayList<SimpleSession> registeredUsers = new ArrayList<SimpleSession>();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            String userName;
            String token = st.nextToken();
            int end = token.indexOf(58);
            ArrayList<String> roles = new ArrayList<String>();
            if (end == -1) {
                userName = token.trim();
            } else {
                userName = token.substring(0, end).trim();
                String roleList = token.substring(end + 1);
                StringTokenizer st2 = new StringTokenizer(roleList, "|");
                while (st2.hasMoreTokens()) {
                    String role = st2.nextToken().trim();
                    roles.add(role);
                }
            }
            registeredUsers.add(this.createSimpleSession(userName, roles));
        }
        return registeredUsers;
    }

    private SimpleSession createSimpleSession(String userName, List<String> roles) {
        return new SimpleSession(userName, roles.toArray(new String[roles.size()]));
    }

    @Override
    public final boolean canAuthenticate(Class<? extends AuthenticationRequest> authenticationRequestClass) {
        return AuthenticationRequestExploration.class.isAssignableFrom(authenticationRequestClass);
    }

    @Override
    protected final boolean isValid(AuthenticationRequest request) {
        return this.getDeploymentCategory().isExploring();
    }

    @Override
    public AuthenticationSession authenticate(AuthenticationRequest request, String code) {
        AuthenticationRequestExploration authenticationRequestExploration = (AuthenticationRequestExploration)request;
        if (!authenticationRequestExploration.isDefaultUser()) {
            this.registeredSessions.add(this.createSimpleSession(authenticationRequestExploration.getName(), authenticationRequestExploration.getRoles()));
        }
        if (this.registeredSessions.size() >= 1) {
            return this.registeredSessions.iterator().next();
        }
        return new ExplorationSession(code);
    }
}

