/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class MetaModelValidatorToCheckObjectSpecIdsUnique
extends MetaModelValidatorComposite {
    public static final String ISIS_REFLECTOR_ENSURE_UNIQUE_OBJECT_IDS_KEY = "isis.reflector.validator.ensureUniqueObjectTypes";
    public static final boolean ISIS_REFLECTOR_ENSURE_UNIQUE_OBJECT_IDS_DEFAULT = true;

    public MetaModelValidatorToCheckObjectSpecIdsUnique() {
        this.addValidatorToEnsureUniqueObjectIds();
    }

    @Override
    public void validate(ValidationFailures validationFailures) {
        boolean check = this.specificationLoader.getConfiguration().getBoolean(ISIS_REFLECTOR_ENSURE_UNIQUE_OBJECT_IDS_KEY, true);
        if (!check) {
            return;
        }
        super.validate(validationFailures);
    }

    private void addValidatorToEnsureUniqueObjectIds() {
        final HashMap specsById = Maps.newHashMap();
        MetaModelValidatorVisiting.SummarizingVisitor ensureUniqueObjectIds = new MetaModelValidatorVisiting.SummarizingVisitor(){

            @Override
            public boolean visit(ObjectSpecification objSpec, ValidationFailures validationFailures) {
                ObjectSpecId specId = objSpec.getSpecId();
                List objectSpecifications = (List)specsById.get(specId);
                if (objectSpecifications == null) {
                    objectSpecifications = Lists.newArrayList();
                    specsById.put(specId, objectSpecifications);
                }
                objectSpecifications.add(objSpec);
                return true;
            }

            @Override
            public void summarize(ValidationFailures validationFailures) {
                for (ObjectSpecId specId : specsById.keySet()) {
                    List specList = (List)specsById.get(specId);
                    int numSpecs = specList.size();
                    if (numSpecs <= 1) continue;
                    String csv = this.asCsv(specList);
                    validationFailures.add("Object type '%s' mapped to multiple classes: %s", specId.asString(), csv);
                }
            }

            private String asCsv(List<ObjectSpecification> specList) {
                return Joiner.on((String)",").join((Iterable)FluentIterable.from(specList).transform(ObjectSpecification.Functions.FULL_IDENTIFIER).toList());
            }
        };
        this.add(new MetaModelValidatorVisiting(ensureUniqueObjectIds));
    }
}

