/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAbstract;

public class MetaModelValidatorForDeprecatedMethodPrefix
extends MetaModelValidatorForDeprecatedAbstract {
    private final String methodPrefix;

    public MetaModelValidatorForDeprecatedMethodPrefix(String methodPrefix) {
        this.methodPrefix = methodPrefix;
    }

    protected String failureMessageFor(Facet facet, FacetFactory.AbstractProcessWithMethodContext processMethodContext) {
        boolean inherited = MetaModelValidatorForDeprecatedMethodPrefix.isInherited(processMethodContext);
        IdentifiedHolder identifiedHolder = (IdentifiedHolder)facet.getFacetHolder();
        Identifier identifier = identifiedHolder.getIdentifier();
        String id = identifier.toFullIdentityString();
        return String.format("%s%s: method prefix '%s' is deprecated", id, inherited ? " (inherited)" : "", this.methodPrefix);
    }
}

