/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorAbstract;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public abstract class MetaModelValidatorForDeprecatedAbstract
extends MetaModelValidatorAbstract {
    public static final String ISIS_REFLECTOR_ALLOW_DEPRECATED_KEY = "isis.reflector.validator.allowDeprecated";
    public static final boolean ISIS_REFLECTOR_ALLOW_DEPRECATED_DEFAULT = true;
    private final ValidationFailures failures = new ValidationFailures();
    private IsisConfiguration configuration;

    public <T extends Facet> T flagIfPresent(T facet) {
        if (facet != null) {
            this.failures.add(this.failureMessageFor(facet, null), new Object[0]);
        }
        return facet;
    }

    public <T extends Facet> T flagIfPresent(T facet, FacetFactory.AbstractProcessWithMethodContext processMethodContext) {
        if (facet != null) {
            this.failures.add(this.failureMessageFor(facet, processMethodContext), new Object[0]);
        }
        return facet;
    }

    static boolean isInherited(FacetFactory.AbstractProcessWithMethodContext<?> processContext) {
        Class<?> declaringClass;
        if (processContext == null) {
            return false;
        }
        Class<?> introspectedCls = processContext.getCls();
        return introspectedCls != (declaringClass = processContext.getMethod().getDeclaringClass());
    }

    protected abstract String failureMessageFor(Facet var1, FacetFactory.AbstractProcessWithMethodContext<?> var2);

    @Override
    public void validate(ValidationFailures validationFailures) {
        if (this.configuration.getBoolean(ISIS_REFLECTOR_ALLOW_DEPRECATED_KEY, true)) {
            return;
        }
        validationFailures.addAll(this.failures);
    }

    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }
}

