/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.autocomplete.PropertyAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.update.init.PropertyInitializationFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.PropertyAccessContext;
import org.apache.isis.core.metamodel.interactions.PropertyModifyContext;
import org.apache.isis.core.metamodel.interactions.PropertyUsabilityContext;
import org.apache.isis.core.metamodel.interactions.PropertyVisibilityContext;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectAssociationAbstract;
import org.apache.isis.schema.cmd.v1.CommandDto;

public class OneToOneAssociationDefault
extends ObjectAssociationAbstract
implements OneToOneAssociation {
    public OneToOneAssociationDefault(FacetedMethod facetedMethod, ServicesInjector servicesInjector) {
        this(facetedMethod, OneToOneAssociationDefault.getSpecification(servicesInjector.getSpecificationLoader(), facetedMethod.getType()), servicesInjector);
    }

    protected OneToOneAssociationDefault(FacetedMethod facetedMethod, ObjectSpecification objectSpec, ServicesInjector servicesInjector) {
        super(facetedMethod, FeatureType.PROPERTY, objectSpec, servicesInjector);
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return new PropertyVisibilityContext(ownerAdapter, this.getIdentifier(), interactionInitiatedBy, where);
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return new PropertyUsabilityContext(ownerAdapter, this.getIdentifier(), interactionInitiatedBy, where);
    }

    private ValidityContext<?> createValidateInteractionContext(ObjectAdapter ownerAdapter, ObjectAdapter proposedToReferenceAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return new PropertyModifyContext(ownerAdapter, this.getIdentifier(), proposedToReferenceAdapter, interactionInitiatedBy);
    }

    @Override
    public Consent isAssociationValid(ObjectAdapter ownerAdapter, ObjectAdapter proposedAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return this.isAssociationValidResult(ownerAdapter, proposedAdapter, interactionInitiatedBy).createConsent();
    }

    private InteractionResult isAssociationValidResult(ObjectAdapter ownerAdapter, ObjectAdapter proposedToReferenceAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ValidityContext<?> validityContext = this.createValidateInteractionContext(ownerAdapter, proposedToReferenceAdapter, interactionInitiatedBy);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public void initAssociation(ObjectAdapter ownerAdapter, ObjectAdapter referencedAdapter) {
        PropertyInitializationFacet initializerFacet = this.getFacet(PropertyInitializationFacet.class);
        if (initializerFacet != null) {
            initializerFacet.initProperty(ownerAdapter, referencedAdapter);
        }
    }

    @Override
    public ObjectAdapter get(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        PropertyOrCollectionAccessorFacet facet = this.getFacet(PropertyOrCollectionAccessorFacet.class);
        Object referencedPojo = facet.getProperty(ownerAdapter, interactionInitiatedBy);
        if (referencedPojo == null) {
            return null;
        }
        return this.getPersistenceSessionService().adapterFor(referencedPojo);
    }

    private PropertyAccessContext createAccessInteractionContext(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter referencedAdapter = this.get(ownerAdapter, interactionInitiatedBy);
        return new PropertyAccessContext(ownerAdapter, this.getIdentifier(), referencedAdapter, interactionInitiatedBy);
    }

    @Override
    public boolean isEmpty(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return this.get(ownerAdapter, interactionInitiatedBy) == null;
    }

    @Override
    public void set(ObjectAdapter ownerAdapter, ObjectAdapter newReferencedAdapter) {
        this.set(ownerAdapter, newReferencedAdapter, InteractionInitiatedBy.USER);
    }

    @Override
    public void set(ObjectAdapter ownerAdapter, ObjectAdapter newReferencedAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        this.setupCommand(ownerAdapter, newReferencedAdapter);
        this.setInternal(ownerAdapter, newReferencedAdapter, interactionInitiatedBy);
    }

    private void setInternal(ObjectAdapter ownerAdapter, ObjectAdapter newReferencedAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        if (newReferencedAdapter != null) {
            this.setValue(ownerAdapter, newReferencedAdapter, interactionInitiatedBy);
        } else {
            this.clearValue(ownerAdapter, interactionInitiatedBy);
        }
    }

    private void setValue(ObjectAdapter ownerAdapter, ObjectAdapter newReferencedAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        PropertySetterFacet setterFacet = this.getFacet(PropertySetterFacet.class);
        if (setterFacet == null) {
            return;
        }
        if (ownerAdapter.representsPersistent() && newReferencedAdapter != null && newReferencedAdapter.isTransient() && !newReferencedAdapter.getSpecification().isParented()) {
            throw new IsisException("can't set a reference to a transient object from a persistent one: " + newReferencedAdapter.titleString(null) + " (transient)");
        }
        setterFacet.setProperty(this, ownerAdapter, newReferencedAdapter, interactionInitiatedBy);
    }

    private void clearValue(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        PropertyClearFacet facet = this.getFacet(PropertyClearFacet.class);
        facet.clearProperty(this, ownerAdapter, interactionInitiatedBy);
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter ownerAdapter) {
        PropertyDefaultFacet propertyDefaultFacet = this.getFacet(PropertyDefaultFacet.class);
        if (propertyDefaultFacet == null || propertyDefaultFacet.isNoop()) {
            propertyDefaultFacet = this.getSpecification().getFacet(PropertyDefaultFacet.class);
        }
        if (propertyDefaultFacet == null) {
            return null;
        }
        return propertyDefaultFacet.getDefault(ownerAdapter);
    }

    @Override
    public void toDefault(ObjectAdapter ownerAdapter) {
        MandatoryFacet mandatoryFacet = this.getFacet(MandatoryFacet.class);
        if (mandatoryFacet != null && mandatoryFacet.isInvertedSemantics()) {
            return;
        }
        ObjectAdapter defaultValue = this.getDefault(ownerAdapter);
        if (defaultValue != null) {
            this.initAssociation(ownerAdapter, defaultValue);
        }
    }

    @Override
    public boolean hasChoices() {
        return this.getFacet(PropertyChoicesFacet.class) != null;
    }

    @Override
    public ObjectAdapter[] getChoices(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        PropertyChoicesFacet propertyChoicesFacet = this.getFacet(PropertyChoicesFacet.class);
        if (propertyChoicesFacet == null) {
            return null;
        }
        Object[] pojoOptions = propertyChoicesFacet.getChoices(ownerAdapter, this.getSpecificationLoader(), interactionInitiatedBy);
        List adapters = Lists.transform((List)Lists.newArrayList((Object[])pojoOptions), ObjectAdapter.Functions.adapterForUsing(this.getPersistenceSessionService()));
        return adapters.toArray(new ObjectAdapter[0]);
    }

    @Override
    public boolean hasAutoComplete() {
        PropertyAutoCompleteFacet propertyAutoCompleteFacet = this.getFacet(PropertyAutoCompleteFacet.class);
        return propertyAutoCompleteFacet != null;
    }

    @Override
    public ObjectAdapter[] getAutoComplete(ObjectAdapter ownerAdapter, String searchArg, InteractionInitiatedBy interactionInitiatedBy) {
        PropertyAutoCompleteFacet propertyAutoCompleteFacet = this.getFacet(PropertyAutoCompleteFacet.class);
        Object[] pojoOptions = propertyAutoCompleteFacet.autoComplete(ownerAdapter, searchArg, interactionInitiatedBy);
        if (pojoOptions != null) {
            ObjectAdapter[] options = new ObjectAdapter[pojoOptions.length];
            for (int i = 0; i < options.length; ++i) {
                options[i] = this.getPersistenceSessionService().adapterFor(pojoOptions[i]);
            }
            return options;
        }
        return null;
    }

    @Override
    public int getAutoCompleteMinLength() {
        PropertyAutoCompleteFacet propertyAutoCompleteFacet = this.getFacet(PropertyAutoCompleteFacet.class);
        return propertyAutoCompleteFacet != null ? propertyAutoCompleteFacet.getMinLength() : 1;
    }

    public void setupCommand(ObjectAdapter targetAdapter, ObjectAdapter valueAdapterOrNull) {
        this.setupCommandTarget(targetAdapter, valueAdapterOrNull);
        this.setupCommandMemberIdentifier();
        this.setupCommandMementoAndExecutionContext(targetAdapter, valueAdapterOrNull);
    }

    private void setupCommandTarget(ObjectAdapter targetAdapter, ObjectAdapter valueAdapter) {
        String arguments = CommandUtil.argDescriptionFor(valueAdapter);
        this.setupCommandTarget(targetAdapter, arguments);
    }

    private void setupCommandMementoAndExecutionContext(ObjectAdapter targetAdapter, ObjectAdapter valueAdapterOrNull) {
        CommandDtoServiceInternal commandDtoServiceInternal = this.getCommandDtoService();
        CommandDto dto = commandDtoServiceInternal.asCommandDto(Collections.singletonList(targetAdapter), this, valueAdapterOrNull);
        this.setupCommandDtoAndExecutionContext(dto);
    }

    @Override
    public String toString() {
        ToString str = new ToString(this);
        str.append(super.toString());
        str.setAddComma();
        str.append("persisted", !this.isNotPersisted());
        str.append("type", this.getSpecification().getShortIdentifier());
        return str.toString();
    }
}

