/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetAbstract;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetForContributee;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacetAbstract;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember2;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationDefault;

public class OneToManyAssociationContributee
extends OneToManyAssociationDefault
implements ContributeeMember2 {
    private final Object servicePojo;
    private final ObjectAction serviceAction;
    private final FacetHolder facetHolder = new FacetHolderImpl();
    private final Identifier identifier;

    private static ObjectSpecification typeOfSpec(ObjectActionDefault objectAction, ServicesInjector objectMemberDependencies) {
        TypeOfFacet actionTypeOfFacet = objectAction.getFacet(TypeOfFacet.class);
        SpecificationLoader specificationLookup = objectMemberDependencies.getSpecificationLoader();
        Class cls = actionTypeOfFacet != null ? actionTypeOfFacet.value() : Object.class;
        return specificationLookup.loadSpecification(cls);
    }

    public OneToManyAssociationContributee(Object servicePojo, ObjectActionDefault serviceAction, ObjectSpecification contributeeType, ServicesInjector servicesInjector) {
        super(serviceAction.getFacetedMethod(), OneToManyAssociationContributee.typeOfSpec(serviceAction, servicesInjector), servicesInjector);
        this.servicePojo = servicePojo;
        this.serviceAction = serviceAction;
        NotPersistedFacetAbstract notPersistedFacet = new NotPersistedFacetAbstract((FacetHolder)this){};
        DisabledFacet disabledFacet = this.disabledFacet();
        TypeOfFacetAbstract typeOfFacet = new TypeOfFacetAbstract(this.getSpecification().getCorrespondingClass(), this, servicesInjector.getSpecificationLoader()){};
        FacetUtil.addFacet(notPersistedFacet);
        FacetUtil.addFacet(disabledFacet);
        FacetUtil.addFacet(typeOfFacet);
        FacetUtil.copyFacets(serviceAction.getFacetedMethod(), this.facetHolder);
        Identifier contributorIdentifier = serviceAction.getFacetedMethod().getIdentifier();
        String memberName = contributorIdentifier.getMemberName();
        List memberParameterNames = contributorIdentifier.getMemberParameterNames();
        this.identifier = Identifier.actionIdentifier((String)contributeeType.getCorrespondingClass().getName(), (String)memberName, (List)memberParameterNames);
    }

    private DisabledFacet disabledFacet() {
        DisabledFacet originalFacet = this.facetHolder.getFacet(DisabledFacet.class);
        if (originalFacet != null && originalFacet.when() == When.ALWAYS && originalFacet.where() == Where.ANYWHERE) {
            return originalFacet;
        }
        return new DisabledFacetForContributee("Contributed collection", this);
    }

    @Override
    public ObjectAdapter get(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return this.serviceAction.execute(this.getServiceAdapter(), null, new ObjectAdapter[]{ownerAdapter}, interactionInitiatedBy);
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.serviceAction.getOnType();
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isContributedBy(ObjectAction serviceAction) {
        return serviceAction == this.serviceAction;
    }

    @Override
    public int getContributeeParamPosition() {
        return 0;
    }

    @Override
    public Consent isVisible(ObjectAdapter contributee, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        VisibilityContext<?> ic = ((ObjectMemberAbstract)((Object)this.serviceAction)).createVisibleInteractionContext(this.getServiceAdapter(), interactionInitiatedBy, where);
        ic.putContributee(0, contributee);
        return InteractionUtils.isVisibleResult(this, ic).createConsent();
    }

    @Override
    public Consent isUsable(ObjectAdapter contributee, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        ObjectMemberAbstract serviceAction = (ObjectMemberAbstract)((Object)this.serviceAction);
        UsabilityContext<?> ic = serviceAction.createUsableInteractionContext(this.getServiceAdapter(), interactionInitiatedBy, where);
        ic.putContributee(0, contributee);
        return InteractionUtils.isUsableResult(this, ic).createConsent();
    }

    @Override
    protected FacetHolder getFacetHolder() {
        return this.facetHolder;
    }

    private ObjectAdapter getServiceAdapter() {
        return this.getPersistenceSessionService().adapterFor(this.servicePojo);
    }

    @Override
    public ObjectSpecification getServiceContributedBy() {
        return this.getServiceAdapter().getSpecification();
    }
}

