/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.List;
import java.util.Objects;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.help.HelpFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionDefault;
import org.apache.isis.schema.cmd.v1.CommandDto;
import org.apache.isis.schema.utils.CommandDtoUtils;

public abstract class ObjectMemberAbstract
implements ObjectMember {
    private final String id;
    private final FacetedMethod facetedMethod;
    private final FeatureType featureType;
    private final SpecificationLoader specificationLoader;
    private final ServicesInjector servicesInjector;
    private final PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public static ObjectSpecification getSpecification(SpecificationLoader specificationLookup, Class<?> type) {
        return type == null ? null : specificationLookup.loadSpecification(type);
    }

    protected ObjectMemberAbstract(FacetedMethod facetedMethod, FeatureType featureType, ServicesInjector servicesInjector) {
        String id = facetedMethod.getIdentifier().getMemberName();
        if (id == null) {
            throw new IllegalArgumentException("Id must always be set");
        }
        this.facetedMethod = facetedMethod;
        this.featureType = featureType;
        this.id = id;
        this.servicesInjector = servicesInjector;
        this.specificationLoader = servicesInjector.getSpecificationLoader();
        this.persistenceSessionServiceInternal = servicesInjector.getPersistenceSessionServiceInternal();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Identifier getIdentifier() {
        return this.getFacetedMethod().getIdentifier();
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public FacetedMethod getFacetedMethod() {
        return this.facetedMethod;
    }

    protected FacetHolder getFacetHolder() {
        return this.getFacetedMethod();
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.getFacetHolder().containsFacet(facetType);
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        return this.getFacetHolder().containsDoOpFacet(facetType);
    }

    @Override
    public boolean containsDoOpNotDerivedFacet(Class<? extends Facet> facetType) {
        return this.getFacetHolder().containsDoOpNotDerivedFacet(facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.getFacetHolder().getFacet(cls);
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.getFacetHolder().getFacetTypes();
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return this.getFacetHolder().getFacets(filter);
    }

    @Override
    public void addFacet(Facet facet) {
        this.getFacetHolder().addFacet(facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        this.getFacetHolder().addFacet(facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        this.getFacetHolder().removeFacet(facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        this.getFacetHolder().removeFacet(facetType);
    }

    @Override
    public String getName() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        String name = facet.value();
        if (name != null) {
            return name;
        }
        return StringExtensions.asNaturalName2(this.getId());
    }

    @Override
    public String getDescription() {
        DescribedAsFacet facet = this.getFacet(DescribedAsFacet.class);
        return (String)facet.value();
    }

    @Override
    public String getHelp() {
        HelpFacet facet = this.getFacet(HelpFacet.class);
        return (String)facet.value();
    }

    protected abstract VisibilityContext<?> createVisibleInteractionContext(ObjectAdapter var1, InteractionInitiatedBy var2, Where var3);

    @Override
    public boolean isAlwaysHidden() {
        HiddenFacet facet = this.getFacet(HiddenFacet.class);
        return facet != null && !facet.isNoop() && facet.when() == When.ALWAYS && (facet.where() == Where.EVERYWHERE || facet.where() == Where.ANYWHERE);
    }

    @Override
    public Consent isVisible(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return this.isVisibleResult(target, interactionInitiatedBy, where).createConsent();
    }

    private InteractionResult isVisibleResult(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        VisibilityContext<?> ic = this.createVisibleInteractionContext(target, interactionInitiatedBy, where);
        return InteractionUtils.isVisibleResult(this, ic);
    }

    protected abstract UsabilityContext<?> createUsableInteractionContext(ObjectAdapter var1, InteractionInitiatedBy var2, Where var3);

    @Override
    public Consent isUsable(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return this.isUsableResult(target, interactionInitiatedBy, where).createConsent();
    }

    private InteractionResult isUsableResult(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        UsabilityContext<?> ic = this.createUsableInteractionContext(target, interactionInitiatedBy, where);
        return InteractionUtils.isUsableResult(this, ic);
    }

    @Override
    public boolean isAction() {
        return this.featureType.isAction();
    }

    @Override
    public boolean isPropertyOrCollection() {
        return this.featureType.isPropertyOrCollection();
    }

    @Override
    public boolean isOneToManyAssociation() {
        return this.featureType.isCollection();
    }

    @Override
    public boolean isOneToOneAssociation() {
        return this.featureType.isProperty();
    }

    ObjectAdapter mixinAdapterFor(Class<?> mixinType, ObjectAdapter mixedInAdapter) {
        ObjectSpecification objectSpecification = this.getSpecificationLoader().loadSpecification(mixinType);
        MixinFacet mixinFacet = objectSpecification.getFacet(MixinFacet.class);
        Object mixinPojo = mixinFacet.instantiate(mixedInAdapter.getObject());
        return this.getPersistenceSessionService().adapterFor(mixinPojo);
    }

    static String determineNameFrom(ObjectAction mixinAction) {
        return StringExtensions.asCapitalizedName(ObjectMemberAbstract.suffix(mixinAction));
    }

    static String determineIdFrom(ObjectActionDefault mixinAction) {
        String id = StringExtensions.asCamelLowerFirst(ObjectMemberAbstract.compress(ObjectMemberAbstract.suffix(mixinAction)));
        return id;
    }

    private static String compress(String suffix) {
        return suffix.replaceAll(" ", "");
    }

    private static String suffix(ObjectAction mixinAction) {
        return ObjectMemberAbstract.deriveMemberNameFrom(mixinAction.getOnType().getSingularName());
    }

    public static String deriveMemberNameFrom(String mixinClassName) {
        String deriveFromUnderscore = ObjectMemberAbstract.derive(mixinClassName, "_");
        if (!Objects.equals(mixinClassName, deriveFromUnderscore)) {
            return deriveFromUnderscore;
        }
        String deriveFromDollar = ObjectMemberAbstract.derive(mixinClassName, "$");
        if (!Objects.equals(mixinClassName, deriveFromDollar)) {
            return deriveFromDollar;
        }
        return mixinClassName;
    }

    private static String derive(String singularName, String separator) {
        int indexOfSeparator = singularName.lastIndexOf(separator);
        return ObjectMemberAbstract.occursNotAtEnd(singularName, indexOfSeparator) ? singularName.substring(indexOfSeparator + 1) : singularName;
    }

    private static boolean occursNotAtEnd(String singularName, int indexOfUnderscore) {
        return indexOfUnderscore != -1 && indexOfUnderscore != singularName.length() - 1;
    }

    public String toString() {
        return String.format("id=%s,name='%s'", this.getId(), this.getName());
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    public PersistenceSessionServiceInternal getPersistenceSessionService() {
        return this.persistenceSessionServiceInternal;
    }

    protected <T> T lookupService(Class<T> serviceClass) {
        return this.getServicesInjector().lookupService(serviceClass);
    }

    protected CommandContext getCommandContext() {
        CommandContext commandContext = this.lookupService(CommandContext.class);
        if (commandContext == null) {
            throw new IllegalStateException("The CommandContext service is not registered!");
        }
        return commandContext;
    }

    protected CommandDtoServiceInternal getCommandDtoService() {
        return this.lookupService(CommandDtoServiceInternal.class);
    }

    protected void setupCommandTarget(ObjectAdapter targetAdapter, String arguments) {
        CommandContext commandContext = this.getCommandContext();
        Command command = commandContext.getCommand();
        if (command.getExecutor() != Command.Executor.USER) {
            return;
        }
        if (command.getTarget() != null) {
            return;
        }
        command.setTargetClass(CommandUtil.targetClassNameFor(targetAdapter));
        command.setTargetAction(CommandUtil.targetMemberNameFor(this));
        command.setArguments(arguments);
        Bookmark targetBookmark = CommandUtil.bookmarkFor(targetAdapter);
        command.setTarget(targetBookmark);
    }

    protected void setupCommandMemberIdentifier() {
        CommandContext commandContext = this.getCommandContext();
        Command command = commandContext.getCommand();
        if (command.getExecutor() != Command.Executor.USER) {
            return;
        }
        if (command.getMemberIdentifier() != null) {
            return;
        }
        command.setMemberIdentifier(CommandUtil.memberIdentifierFor(this));
    }

    protected void setupCommandDtoAndExecutionContext(CommandDto dto) {
        CommandContext commandContext = this.getCommandContext();
        Command command = commandContext.getCommand();
        if (command.getExecutor() != Command.Executor.USER) {
            return;
        }
        if (command.getMemento() != null) {
            return;
        }
        String mementoXml = CommandDtoUtils.toXml((CommandDto)dto);
        command.setMemento(mementoXml);
        CommandFacet commandFacet = this.getFacetHolder().getFacet(CommandFacet.class);
        if (commandFacet != null && !commandFacet.isDisabled()) {
            command.setExecuteIn(commandFacet.executeIn());
            command.setPersistence(commandFacet.persistence());
        } else {
            command.setExecuteIn(Command.ExecuteIn.FOREGROUND);
            command.setPersistence(Command.Persistence.IF_HINTED);
        }
    }
}

