/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember2;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterContributeeAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyActionParameterContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneActionParameterContributee;

public class ObjectActionContributee
extends ObjectActionDefault
implements ContributeeMember2 {
    private final Object servicePojo;
    private final ObjectActionDefault serviceAction;
    private final int contributeeParam;
    private final ObjectSpecification contributeeType;
    private final FacetHolder facetHolder = new FacetHolderImpl();
    private final Identifier identifier;

    public ObjectActionContributee(Object servicePojo, ObjectActionDefault serviceAction, int contributeeParam, ObjectSpecification contributeeType, ServicesInjector servicesInjector) {
        super(serviceAction.getFacetedMethod(), servicesInjector);
        this.servicePojo = servicePojo;
        this.serviceAction = serviceAction;
        this.contributeeType = contributeeType;
        this.contributeeParam = contributeeParam;
        FacetUtil.copyFacets(serviceAction.getFacetedMethod(), this.facetHolder);
        Identifier contributorIdentifier = serviceAction.getFacetedMethod().getIdentifier();
        String memberName = contributorIdentifier.getMemberName();
        List memberParameterNames = contributorIdentifier.getMemberParameterNames();
        this.identifier = Identifier.actionIdentifier((String)this.getOnType().getCorrespondingClass().getName(), (String)memberName, (List)memberParameterNames);
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.contributeeType;
    }

    @Override
    public int getParameterCount() {
        return this.serviceAction.getParameterCount() - 1;
    }

    public int getContributeeParam() {
        return this.contributeeParam;
    }

    @Override
    public boolean isContributedBy(ObjectAction serviceAction) {
        return serviceAction == this.serviceAction;
    }

    @Override
    public int getContributeeParamPosition() {
        return this.contributeeParam;
    }

    @Override
    protected synchronized List<ObjectActionParameter> determineParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        List<ObjectActionParameter> serviceParameters = this.serviceAction.getParameters();
        List<FacetedMethodParameter> paramPeers = this.getFacetedMethod().getParameters();
        ArrayList contributeeParameters = Lists.newArrayList();
        int contributeeParamNum = 0;
        for (int serviceParamNum = 0; serviceParamNum < serviceParameters.size(); ++serviceParamNum) {
            if (serviceParamNum == this.contributeeParam) continue;
            ObjectActionParameterAbstract serviceParameter = (ObjectActionParameterAbstract)serviceParameters.get(serviceParamNum);
            ObjectActionParameterContributeeAbstract contributedParam = serviceParameter.getPeer().getFeatureType() == FeatureType.ACTION_PARAMETER_SCALAR ? new OneToOneActionParameterContributee(this.servicePojo, serviceParameter, contributeeParamNum, this) : new OneToManyActionParameterContributee(this.servicePojo, serviceParameter, contributeeParamNum, this);
            contributeeParameters.add(contributedParam);
            ++contributeeParamNum;
        }
        return contributeeParameters;
    }

    @Override
    public Consent isVisible(ObjectAdapter contributee, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        VisibilityContext<?> ic = this.serviceAction.createVisibleInteractionContext(this.getServiceAdapter(), interactionInitiatedBy, where);
        ic.putContributee(this.contributeeParam, contributee);
        return InteractionUtils.isVisibleResult(this, ic).createConsent();
    }

    @Override
    public Consent isUsable(ObjectAdapter contributee, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        UsabilityContext<?> ic = this.serviceAction.createUsableInteractionContext(this.getServiceAdapter(), interactionInitiatedBy, where);
        ic.putContributee(this.contributeeParam, contributee);
        return InteractionUtils.isUsableResult(this, ic).createConsent();
    }

    @Override
    public ObjectAdapter[] getDefaults(ObjectAdapter target) {
        ObjectAdapter[] contributorDefaults = this.serviceAction.getDefaults(this.getServiceAdapter());
        return ObjectActionContributee.removeElementFromArray(contributorDefaults, this.contributeeParam, new ObjectAdapter[0]);
    }

    @Override
    public ObjectAdapter[][] getChoices(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter[][] serviceChoices = this.serviceAction.getChoices(this.getServiceAdapter(), interactionInitiatedBy);
        return (ObjectAdapter[][])ObjectActionContributee.removeElementFromArray(serviceChoices, this.contributeeParam, new ObjectAdapter[0][]);
    }

    @Override
    public Consent isProposedArgumentSetValid(ObjectAdapter contributee, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter[] serviceArguments = this.argsPlusContributee(contributee, proposedArguments);
        return this.serviceAction.isProposedArgumentSetValid(this.getServiceAdapter(), serviceArguments, interactionInitiatedBy);
    }

    @Override
    public Consent isEachIndividualArgumentValid(ObjectAdapter contributee, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter[] serviceArguments = this.argsPlusContributee(contributee, proposedArguments);
        return this.serviceAction.isEachIndividualArgumentValid(this.getServiceAdapter(), serviceArguments, interactionInitiatedBy);
    }

    @Override
    public Consent isArgumentSetValid(ObjectAdapter contributee, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter[] serviceArguments = this.argsPlusContributee(contributee, proposedArguments);
        return this.serviceAction.isArgumentSetValid(this.getServiceAdapter(), serviceArguments, interactionInitiatedBy);
    }

    @Override
    public ObjectAdapter execute(ObjectAdapter targetAdapter, ObjectAdapter mixedInAdapter, ObjectAdapter[] argumentAdapters, InteractionInitiatedBy interactionInitiatedBy) {
        this.setupCommand(targetAdapter, argumentAdapters);
        ObjectAdapter[] serviceArguments = this.argsPlusContributee(targetAdapter, argumentAdapters);
        return this.serviceAction.executeInternal(this.getServiceAdapter(), mixedInAdapter, serviceArguments, interactionInitiatedBy);
    }

    private ObjectAdapter[] argsPlusContributee(ObjectAdapter contributee, ObjectAdapter[] arguments) {
        return ObjectActionContributee.addElementToArray(arguments, this.contributeeParam, contributee, new ObjectAdapter[0]);
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.facetHolder.getFacetTypes();
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.facetHolder.getFacet(cls);
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.facetHolder.containsFacet(facetType);
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        return this.facetHolder.containsDoOpFacet(facetType);
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return this.facetHolder.getFacets(filter);
    }

    @Override
    public void addFacet(Facet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        this.facetHolder.removeFacet(facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        this.facetHolder.removeFacet(facetType);
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    static <T> T[] addElementToArray(T[] array, int n, T element, T[] type) {
        ArrayList list = Lists.newArrayList(Arrays.asList(array));
        list.add(n, element);
        return list.toArray(type);
    }

    static <T> T[] removeElementFromArray(T[] array, int n, T[] t) {
        ArrayList list = Lists.newArrayList(Arrays.asList(array));
        list.remove(n);
        return list.toArray(t);
    }

    public ObjectAdapter getServiceAdapter() {
        return this.getPersistenceSessionService().adapterFor(this.servicePojo);
    }

    @Override
    public ObjectSpecification getServiceContributedBy() {
        return this.getServiceAdapter().getSpecification();
    }
}

