/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.postprocessor;

import java.util.List;
import org.apache.isis.core.metamodel.progmodel.ObjectSpecificationPostProcessor;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class PostProcessor {
    private final ProgrammingModel programmingModel;
    private final ServicesInjector servicesInjector;
    List<ObjectSpecificationPostProcessor> postProcessors;

    public PostProcessor(ProgrammingModel programmingModel, ServicesInjector servicesInjector) {
        this.programmingModel = programmingModel;
        this.servicesInjector = servicesInjector;
    }

    public void init() {
        this.postProcessors = this.programmingModel.getPostProcessors();
        for (ObjectSpecificationPostProcessor postProcessor : this.postProcessors) {
            if (!(postProcessor instanceof ServicesInjectorAware)) continue;
            ServicesInjectorAware servicesInjectorAware = (ServicesInjectorAware)((Object)postProcessor);
            servicesInjectorAware.setServicesInjector(this.servicesInjector);
        }
    }

    public void postProcess(ObjectSpecification objectSpecification) {
        for (ObjectSpecificationPostProcessor postProcessor : this.postProcessors) {
            postProcessor.postProcess(objectSpecification);
        }
    }
}

