/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInitializer.class);
    private final List<Object> services;
    private final Map<String, String> props;
    private Map<Object, Method> postConstructMethodsByService = Maps.newLinkedHashMap();
    private Map<Object, Method> preDestroyMethodsByService = Maps.newLinkedHashMap();

    public ServiceInitializer(IsisConfiguration configuration, List<Object> services) {
        this.props = configuration.asMap();
        this.services = services;
    }

    public void validate() {
        for (Object service : this.services) {
            Class<?>[] parameterTypes;
            Method existing;
            Method[] methods;
            LOG.debug("checking for @PostConstruct and @PostDestroy methods on {}", (Object)service.getClass().getName());
            for (Method method : methods = service.getClass().getMethods()) {
                PostConstruct postConstructAnnotation = method.getAnnotation(PostConstruct.class);
                if (postConstructAnnotation == null) continue;
                existing = this.postConstructMethodsByService.get(service);
                if (existing != null) {
                    throw new RuntimeException("Found more than one @PostConstruct method; service is: " + service.getClass().getName() + ", found " + existing.getName() + " and " + method.getName());
                }
                parameterTypes = method.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (Map.class == parameterTypes[0]) break;
                        throw new RuntimeException("@PostConstruct method must be no-arg or 1-arg accepting java.util.Map; method is: " + service.getClass().getName() + "#" + method.getName());
                    }
                    default: {
                        throw new RuntimeException("@PostConstruct method must be no-arg or 1-arg accepting java.util.Map; method is: " + service.getClass().getName() + "#" + method.getName());
                    }
                }
                this.postConstructMethodsByService.put(service, method);
            }
            for (Method method : methods) {
                PreDestroy preDestroyAnnotation = method.getAnnotation(PreDestroy.class);
                if (preDestroyAnnotation == null) continue;
                existing = this.preDestroyMethodsByService.get(service);
                if (existing != null) {
                    throw new RuntimeException("Found more than one @PreDestroy method; service is: " + service.getClass().getName() + ", found " + existing.getName() + " and " + method.getName());
                }
                parameterTypes = method.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("@PreDestroy method must be no-arg; method is: " + service.getClass().getName() + "#" + method.getName());
                    }
                }
                this.preDestroyMethodsByService.put(service, method);
            }
        }
    }

    public void postConstruct() {
        if (LOG.isInfoEnabled()) {
            LOG.info("calling @PostConstruct on all domain services");
        }
        Exception firstExceptionIfAny = null;
        for (Map.Entry<Object, Method> entry : this.postConstructMethodsByService.entrySet()) {
            Object service = entry.getKey();
            Method method = entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("... calling @PostConstruct method: " + service.getClass().getName() + ": " + method.getName());
            }
            int numParams = method.getParameterTypes().length;
            try {
                if (numParams == 0) {
                    MethodExtensions.invoke(method, service);
                    continue;
                }
                MethodExtensions.invoke(method, service, new Object[]{this.props});
            }
            catch (Exception ex) {
                LOG.error(String.format("@PostConstruct on %s#%s: failed", service.getClass().getName(), method.getName()), (Throwable)ex);
                if (firstExceptionIfAny != null) continue;
                firstExceptionIfAny = ex;
            }
        }
        if (firstExceptionIfAny != null) {
            throw new RuntimeException(firstExceptionIfAny);
        }
    }

    public void preDestroy() {
        if (LOG.isInfoEnabled()) {
            LOG.info("calling @PreDestroy on all domain services");
        }
        for (Map.Entry<Object, Method> entry : this.preDestroyMethodsByService.entrySet()) {
            Object service = entry.getKey();
            Method method = entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("... calling @PreDestroy method: {}: {}", (Object)service.getClass().getName(), (Object)method.getName());
            }
            try {
                MethodExtensions.invoke(method, service);
            }
            catch (Exception ex) {
                LOG.warn(String.format("@PreDestroy on %s#%s: failed, continuing anyway", service.getClass().getName(), method.getName()));
            }
        }
    }
}

