/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.isis.applib.annotation.Programmatic;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isCollectionType(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    public static boolean isArrayType(Class<?> cls) {
        return cls.isArray();
    }

    public static Class<?> inferFromArrayType(Class<?> type) {
        if (!CollectionUtils.isArrayType(type)) {
            return null;
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return componentType;
        }
        return null;
    }

    @Programmatic
    public static Class<?> inferFromGenericParamType(Class<?> parameterType, Type genericParameterType) {
        Type actualTypeArgument;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (!CollectionUtils.isCollectionType(parameterType)) {
            return null;
        }
        if (genericParameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericParameterType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
            Class actualType = (Class)actualTypeArgument;
            return actualType;
        }
        return null;
    }

    public static boolean isParamCollection(Class<?> parameterType, Type genericParameterType) {
        return CollectionUtils.inferFromGenericParamType(parameterType, genericParameterType) != null || CollectionUtils.inferFromArrayType(parameterType) != null;
    }
}

