/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderFacetComparator;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;

public interface ObjectMember
extends ObjectFeature {
    public String getHelp();

    public boolean isAlwaysHidden();

    public Consent isVisible(ObjectAdapter var1, InteractionInitiatedBy var2, Where var3);

    public Consent isUsable(ObjectAdapter var1, InteractionInitiatedBy var2, Where var3);

    public boolean isPropertyOrCollection();

    public boolean isOneToManyAssociation();

    public boolean isOneToOneAssociation();

    public boolean isAction();

    public static class Comparators {
        public static Comparator<ObjectMember> byMemberOrderSequence() {
            return new Comparator<ObjectMember>(){
                private final MemberOrderFacetComparator memberOrderFacetComparator = new MemberOrderFacetComparator(false);

                @Override
                public int compare(ObjectMember o1, ObjectMember o2) {
                    return this.memberOrderFacetComparator.compare(o1.getFacet(MemberOrderFacet.class), o2.getFacet(MemberOrderFacet.class));
                }
            };
        }
    }

    public static class Util {
        private Util() {
        }

        public static <T extends ObjectMember> HashMap<String, T> mapById(List<T> members) {
            LinkedHashMap memberById = Maps.newLinkedHashMap();
            for (ObjectMember member : members) {
                String id = (String)Functions.getId().apply((Object)member);
                memberById.put(id, member);
            }
            return memberById;
        }
    }

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectMember, String> getId() {
            return new Function<ObjectMember, String>(){

                @Nullable
                public String apply(@Nullable ObjectMember oneToOneAssociation) {
                    return oneToOneAssociation.getId();
                }
            };
        }
    }

    public static class DisabledException
    extends AuthorizationException {
        public DisabledException(String message) {
            super(message, null);
        }

        public static Predicate<Throwable> isInstanceOf() {
            return new Predicate<Throwable>(){

                public boolean apply(@Nullable Throwable throwable) {
                    return throwable instanceof DisabledException;
                }
            };
        }
    }

    public static class HiddenException
    extends AuthorizationException {
        public HiddenException() {
            super((RuntimeException)null);
        }

        public static Predicate<Throwable> isInstanceOf() {
            return new Predicate<Throwable>(){

                public boolean apply(@Nullable Throwable throwable) {
                    return throwable instanceof HiddenException;
                }
            };
        }
    }

    public static class AuthorizationException
    extends RuntimeException {
        public AuthorizationException() {
            this((RuntimeException)null);
        }

        public AuthorizationException(RuntimeException ex) {
            this("Not authorized or no such object", ex);
        }

        public AuthorizationException(String message, RuntimeException ex) {
            super(message, ex);
        }
    }
}

