/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.WhenAndWhereValueFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderComparator;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.CurrentHolder;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.util.DeweyOrderComparator;

public interface ObjectAssociation
extends ObjectMember,
CurrentHolder {
    public ObjectAdapter get(ObjectAdapter var1);

    @Override
    public ObjectAdapter get(ObjectAdapter var1, InteractionInitiatedBy var2);

    public ObjectAdapter getDefault(ObjectAdapter var1);

    public void toDefault(ObjectAdapter var1);

    public boolean hasChoices();

    public ObjectAdapter[] getChoices(ObjectAdapter var1, InteractionInitiatedBy var2);

    public boolean hasAutoComplete();

    public ObjectAdapter[] getAutoComplete(ObjectAdapter var1, String var2, InteractionInitiatedBy var3);

    public int getAutoCompleteMinLength();

    public boolean isNotPersisted();

    public boolean isEmpty(ObjectAdapter var1, InteractionInitiatedBy var2);

    public boolean isMandatory();

    public ObjectSpecification getOnType();

    public static class Util {
        private Util() {
        }

        public static Map<String, List<ObjectAssociation>> groupByMemberOrderName(List<ObjectAssociation> associations) {
            HashMap associationsByGroup = Maps.newHashMap();
            for (ObjectAssociation objectAssociation : associations) {
                Util.addAssociationIntoGroup(associationsByGroup, objectAssociation);
            }
            for (Map.Entry entry : associationsByGroup.entrySet()) {
                Collections.sort((List)entry.getValue(), new MemberOrderComparator(true));
            }
            return associationsByGroup;
        }

        private static void addAssociationIntoGroup(Map<String, List<ObjectAssociation>> associationsByGroup, ObjectAssociation association) {
            String untranslatedName;
            MemberOrderFacet memberOrderFacet = association.getFacet(MemberOrderFacet.class);
            if (memberOrderFacet != null && !Strings.isNullOrEmpty((String)(untranslatedName = memberOrderFacet.untranslatedName()))) {
                Util.getFrom(associationsByGroup, untranslatedName).add(association);
                return;
            }
            Util.getFrom(associationsByGroup, "General").add(association);
        }

        private static List<ObjectAssociation> getFrom(Map<String, List<ObjectAssociation>> associationsByGroup, String groupName) {
            ArrayList list = associationsByGroup.get(groupName);
            if (list == null) {
                list = Lists.newArrayList();
                associationsByGroup.put(groupName, list);
            }
            return list;
        }
    }

    public static class Comparators {
        @Deprecated
        public static Comparator<ObjectAssociation> byMemberOrderSequence() {
            return new Comparator<ObjectAssociation>(){
                private final DeweyOrderComparator deweyOrderComparator = new DeweyOrderComparator();

                @Override
                public int compare(ObjectAssociation o1, ObjectAssociation o2) {
                    MemberOrderFacet o1Facet = o1.getFacet(MemberOrderFacet.class);
                    MemberOrderFacet o2Facet = o2.getFacet(MemberOrderFacet.class);
                    return o1Facet == null ? 1 : (o2Facet == null ? -1 : this.deweyOrderComparator.compare(o1Facet.sequence(), o2Facet.sequence()));
                }
            };
        }
    }

    public static class Filters {
        @Deprecated
        public static final Filter<ObjectAssociation> PROPERTIES = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                return association.isOneToOneAssociation();
            }
        };
        @Deprecated
        public static final Filter<ObjectAssociation> REFERENCE_PROPERTIES = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                return association.isOneToOneAssociation() && !association.getSpecification().containsDoOpFacet(ValueFacet.class);
            }
        };
        @Deprecated
        public static final Filter<ObjectAssociation> WHERE_VISIBLE_IN_COLLECTION_TABLE = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                HiddenFacet hiddenFacet = association.getFacet(HiddenFacet.class);
                return hiddenFacet == null || !hiddenFacet.where().inParentedTable();
            }
        };
        @Deprecated
        public static final Filter<ObjectAssociation> WHERE_VISIBLE_IN_STANDALONE_TABLE = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                HiddenFacet hiddenFacet = association.getFacet(HiddenFacet.class);
                return hiddenFacet == null || !hiddenFacet.where().inStandaloneTable();
            }
        };
        @Deprecated
        public static final Filter<ObjectAssociation> ALL = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation property) {
                return true;
            }
        };
        @Deprecated
        public static final Filter<ObjectAssociation> COLLECTIONS = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation property) {
                return property.isOneToManyAssociation();
            }
        };
        @Deprecated
        public static final Filter<ObjectAssociation> VISIBLE_AT_LEAST_SOMETIMES = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation property) {
                HiddenFacet hiddenFacet = property.getFacet(HiddenFacet.class);
                return hiddenFacet == null || hiddenFacet.when() != When.ALWAYS || hiddenFacet.where() != Where.ANYWHERE;
            }
        };

        private Filters() {
        }

        @Deprecated
        public static final Filter<ObjectAssociation> staticallyVisible(final Where context) {
            return new Filter<ObjectAssociation>(){

                public boolean accept(ObjectAssociation association) {
                    List<Facet> facets = association.getFacets(new Filter<Facet>(){

                        public boolean accept(Facet facet) {
                            return facet instanceof WhenAndWhereValueFacet && facet instanceof HiddenFacet;
                        }
                    });
                    for (Facet facet : facets) {
                        WhenAndWhereValueFacet wawF = (WhenAndWhereValueFacet)facet;
                        if (!wawF.where().includes(context) || wawF.when() != When.ALWAYS) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAssociation> dynamicallyVisible(final ObjectAdapter target, final InteractionInitiatedBy interactionInitiatedBy, final Where where) {
            return new Filter<ObjectAssociation>(){

                public boolean accept(ObjectAssociation objectAssociation) {
                    Consent visible = objectAssociation.isVisible(target, interactionInitiatedBy, where);
                    return visible.isAllowed();
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAssociation> enabled(final ObjectAdapter adapter, final InteractionInitiatedBy interactionInitiatedBy, final Where where) {
            return new Filter<ObjectAssociation>(){

                public boolean accept(ObjectAssociation objectAssociation) {
                    Consent usable = objectAssociation.isUsable(adapter, interactionInitiatedBy, where);
                    return usable.isAllowed();
                }
            };
        }
    }

    public static class Predicates {
        public static final Predicate<ObjectAssociation> PROPERTIES = org.apache.isis.applib.filter.Filters.asPredicate(Filters.PROPERTIES);
        public static final Predicate<ObjectAssociation> REFERENCE_PROPERTIES = org.apache.isis.applib.filter.Filters.asPredicate(Filters.REFERENCE_PROPERTIES);
        public static final Predicate<ObjectAssociation> WHERE_VISIBLE_IN_COLLECTION_TABLE = org.apache.isis.applib.filter.Filters.asPredicate(Filters.WHERE_VISIBLE_IN_COLLECTION_TABLE);
        public static final Predicate<ObjectAssociation> WHERE_VISIBLE_IN_STANDALONE_TABLE = org.apache.isis.applib.filter.Filters.asPredicate(Filters.WHERE_VISIBLE_IN_STANDALONE_TABLE);
        public static final Predicate<ObjectAssociation> ALL = org.apache.isis.applib.filter.Filters.asPredicate(Filters.ALL);
        public static final Predicate<ObjectAssociation> COLLECTIONS = org.apache.isis.applib.filter.Filters.asPredicate(Filters.COLLECTIONS);
        public static final Predicate<ObjectAssociation> VISIBLE_AT_LEAST_SOMETIMES = org.apache.isis.applib.filter.Filters.asPredicate(Filters.VISIBLE_AT_LEAST_SOMETIMES);

        private Predicates() {
        }

        public static Predicate<ObjectAssociation> being(final Contributed contributed) {
            return new Predicate<ObjectAssociation>(){

                public boolean apply(ObjectAssociation t) {
                    return contributed.isIncluded() || !(t instanceof ContributeeMember);
                }
            };
        }

        public static final Predicate<ObjectAssociation> staticallyVisible(Where context) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.staticallyVisible(context));
        }

        public static final Predicate<ObjectAssociation> dynamicallyVisible(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy, Where where) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.dynamicallyVisible(target, interactionInitiatedBy, where));
        }

        public static final Predicate<ObjectAssociation> enabled(ObjectAdapter adapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.enabled(adapter, interactionInitiatedBy, where));
        }
    }

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectAssociation, String> toName() {
            return new Function<ObjectAssociation, String>(){

                public String apply(ObjectAssociation oa) {
                    return oa.getName();
                }
            };
        }

        public static Function<ObjectAssociation, String> toId() {
            return new Function<ObjectAssociation, String>(){

                public String apply(ObjectAssociation oa) {
                    return oa.getId();
                }
            };
        }
    }
}

