/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.xactn;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.xactn.Transaction2;
import org.apache.isis.applib.services.xactn.TransactionService3;
import org.apache.isis.applib.services.xactn.TransactionState;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class TransactionServiceDefault
implements TransactionService3 {
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public void flushTransaction() {
        this.persistenceSessionServiceInternal.flush();
    }

    public void nextTransaction() {
        this.nextTransaction((Command)null);
    }

    public void nextTransaction(Command command) {
        this.nextTransaction(TransactionService3.Policy.UNLESS_MARKED_FOR_ABORT, command);
    }

    public void nextTransaction(TransactionService3.Policy policy) {
        this.nextTransaction(policy, null);
    }

    public void nextTransaction(TransactionService3.Policy policy, Command commandIfAny) {
        TransactionState transactionState = this.getTransactionState();
        switch (transactionState) {
            case NONE: {
                break;
            }
            case IN_PROGRESS: {
                this.persistenceSessionServiceInternal.commit();
                break;
            }
            case MUST_ABORT: {
                switch (policy) {
                    case UNLESS_MARKED_FOR_ABORT: {
                        throw new IsisException("Transaction is marked to abort");
                    }
                    case ALWAYS: {
                        this.persistenceSessionServiceInternal.abortTransaction();
                        this.currentTransaction().clearAbortCause();
                    }
                }
                break;
            }
            case COMMITTED: {
                break;
            }
        }
        this.persistenceSessionServiceInternal.beginTran(commandIfAny);
    }

    public Transaction2 currentTransaction() {
        return this.persistenceSessionServiceInternal.currentTransaction();
    }

    public TransactionState getTransactionState() {
        return this.persistenceSessionServiceInternal.getTransactionState();
    }
}

