/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ValuePropertyFactory {
    private final Map<Class, Factory> propertyFactoryByClass = Maps.newHashMap();

    public ValuePropertyFactory() {
        Factory booleanFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new BooleanProperty();
            }
        };
        this.propertyFactoryByClass.put(Boolean.TYPE, booleanFactory);
        this.propertyFactoryByClass.put(Boolean.class, booleanFactory);
        Factory integerFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new IntegerProperty();
            }
        };
        this.propertyFactoryByClass.put(Byte.TYPE, integerFactory);
        this.propertyFactoryByClass.put(Byte.class, integerFactory);
        this.propertyFactoryByClass.put(Short.TYPE, integerFactory);
        this.propertyFactoryByClass.put(Short.class, integerFactory);
        this.propertyFactoryByClass.put(Integer.TYPE, integerFactory);
        this.propertyFactoryByClass.put(Integer.class, integerFactory);
        this.propertyFactoryByClass.put(BigInteger.class, integerFactory);
        Factory longFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new LongProperty();
            }
        };
        this.propertyFactoryByClass.put(Long.TYPE, longFactory);
        this.propertyFactoryByClass.put(Long.class, longFactory);
        this.propertyFactoryByClass.put(Timestamp.class, longFactory);
        Factory decimalFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new DecimalProperty();
            }
        };
        this.propertyFactoryByClass.put(BigDecimal.class, decimalFactory);
        Factory floatFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new FloatProperty();
            }
        };
        this.propertyFactoryByClass.put(Float.TYPE, floatFactory);
        this.propertyFactoryByClass.put(Float.class, floatFactory);
        Factory doubleFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new DoubleProperty();
            }
        };
        this.propertyFactoryByClass.put(Double.TYPE, doubleFactory);
        this.propertyFactoryByClass.put(Double.class, doubleFactory);
        Factory stringFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new StringProperty();
            }
        };
        this.propertyFactoryByClass.put(Character.TYPE, stringFactory);
        this.propertyFactoryByClass.put(Character.class, stringFactory);
        this.propertyFactoryByClass.put(char[].class, stringFactory);
        this.propertyFactoryByClass.put(String.class, stringFactory);
        Factory uuidFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new UUIDProperty();
            }
        };
        this.propertyFactoryByClass.put(UUID.class, uuidFactory);
        Factory dateTimeFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new DateTimeProperty();
            }
        };
        this.propertyFactoryByClass.put(java.util.Date.class, dateTimeFactory);
        this.propertyFactoryByClass.put(org.joda.time.DateTime.class, dateTimeFactory);
        this.propertyFactoryByClass.put(LocalDateTime.class, dateTimeFactory);
        this.propertyFactoryByClass.put(DateTime.class, dateTimeFactory);
        Factory dateFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new DateProperty();
            }
        };
        this.propertyFactoryByClass.put(Date.class, dateFactory);
        this.propertyFactoryByClass.put(LocalDate.class, dateFactory);
        this.propertyFactoryByClass.put(org.apache.isis.applib.value.Date.class, dateFactory);
        Factory byteArrayFactory = new Factory(){

            @Override
            public Property newProperty() {
                return new ByteArrayProperty();
            }
        };
        this.propertyFactoryByClass.put(byte[].class, byteArrayFactory);
        this.propertyFactoryByClass.put(Blob.class, byteArrayFactory);
    }

    public Property newProperty(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        Factory factory = this.propertyFactoryByClass.get(cls);
        if (factory != null) {
            return factory.newProperty();
        }
        if (cls.isEnum()) {
            StringProperty property = new StringProperty();
            ?[] enumConstants = cls.getEnumConstants();
            ArrayList enumNames = Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(enumConstants), (Function)new Function<Object, String>(){

                @Nullable
                public String apply(@Nullable Object input) {
                    return ((Enum)input).name();
                }
            }));
            property.setEnum((List)enumNames);
            return property;
        }
        return null;
    }

    static interface Factory {
        public Property newProperty();
    }
}

