/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.services.swagger.internal.Caching;
import org.apache.isis.core.metamodel.services.swagger.internal.ClassExcluder;
import org.apache.isis.core.metamodel.services.swagger.internal.Tagger;
import org.apache.isis.core.metamodel.services.swagger.internal.Util;
import org.apache.isis.core.metamodel.services.swagger.internal.ValuePropertyFactory;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

class Generation {
    private final String basePath;
    private final SwaggerService.Visibility visibility;
    private final SpecificationLoader specificationLoader;
    private final ValuePropertyFactory valuePropertyFactory;
    private final Tagger tagger;
    private final ClassExcluder classExcluder;
    private final Set<String> references = Sets.newLinkedHashSet();
    private final Set<String> definitions = Sets.newLinkedHashSet();
    private Swagger swagger;

    public Generation(String basePath, SwaggerService.Visibility visibility, SpecificationLoader specificationLoader) {
        this.basePath = basePath;
        this.visibility = visibility;
        this.specificationLoader = specificationLoader;
        this.valuePropertyFactory = this.newValuePropertyFactory();
        this.tagger = this.newTagger();
        this.classExcluder = this.newClassExcluder();
    }

    protected ValuePropertyFactory newValuePropertyFactory() {
        return new ValuePropertyFactory();
    }

    protected ClassExcluder newClassExcluder() {
        return new ClassExcluder();
    }

    protected Tagger newTagger() {
        return new Tagger();
    }

    Swagger generate() {
        this.swagger = new Swagger();
        this.swagger.basePath(this.basePath);
        this.swagger.info(new Info().version("0.0.0").title(this.visibility.name() + " API"));
        this.appendRestfulObjectsSupportingPathsAndDefinitions();
        this.appendLinkModelDefinition();
        this.appendServicePathsAndDefinitions();
        this.appendObjectPathsAndDefinitions();
        this.appendDefinitionsForOrphanedReferences();
        return this.swagger;
    }

    void appendServicePathsAndDefinitions() {
        for (ObjectSpecification objectSpec : this.specificationLoader.allSpecifications()) {
            List<ObjectAction> serviceActions;
            DomainServiceFacet domainServiceFacet = objectSpec.getFacet(DomainServiceFacet.class);
            if (domainServiceFacet == null || this.visibility.isPublic() && domainServiceFacet.getNatureOfService() != NatureOfService.VIEW_REST_ONLY || domainServiceFacet.getNatureOfService() != NatureOfService.VIEW_MENU_ONLY && domainServiceFacet.getNatureOfService() != NatureOfService.VIEW && domainServiceFacet.getNatureOfService() != NatureOfService.VIEW_REST_ONLY || (serviceActions = Util.actionsOf(objectSpec, this.visibility, this.classExcluder)).isEmpty()) continue;
            this.appendServicePath(objectSpec);
            for (ObjectAction serviceAction : serviceActions) {
                this.appendServiceActionInvokePath(objectSpec, serviceAction);
            }
        }
    }

    private void debugTraverseAllSpecs(Collection<ObjectSpecification> allSpecs) {
        for (ObjectSpecification objectSpec : allSpecs) {
            objectSpec.getAssociations(Contributed.INCLUDED);
            objectSpec.getObjectActions(Contributed.INCLUDED);
        }
    }

    private void debugAllLoadedClasses(Collection<ObjectSpecification> allSpecs) {
        ImmutableList specs = FluentIterable.from(allSpecs).transform((Function)new Function<ObjectSpecification, String>(){

            @Nullable
            public String apply(@Nullable ObjectSpecification objectSpecification) {
                return objectSpecification.getCorrespondingClass().getName();
            }
        }).toSortedList((Comparator)Ordering.natural());
        String all = Joiner.on((String)",").join((Iterable)specs);
        System.out.println(all);
    }

    void appendObjectPathsAndDefinitions() {
        for (ObjectSpecification objectSpec : this.specificationLoader.allSpecifications()) {
            MixinFacet mixinFacet;
            DomainServiceFacet domainServiceFacet = objectSpec.getFacet(DomainServiceFacet.class);
            if (domainServiceFacet != null || (mixinFacet = objectSpec.getFacet(MixinFacet.class)) != null || this.visibility.isPublic() && !Util.isVisibleForPublic(objectSpec) || objectSpec.isAbstract() || objectSpec.isValue() || this.classExcluder.exclude(objectSpec)) continue;
            List<OneToOneAssociation> objectProperties = Util.propertiesOf(objectSpec, this.visibility);
            List<OneToManyAssociation> objectCollections = Util.collectionsOf(objectSpec, this.visibility);
            List<ObjectAction> objectActions = Util.actionsOf(objectSpec, this.visibility, this.classExcluder);
            if (objectProperties.isEmpty() && objectCollections.isEmpty()) continue;
            ModelImpl isisModel = this.appendObjectPathAndModelDefinitions(objectSpec);
            this.updateObjectModel(isisModel, objectSpec, objectProperties, objectCollections);
            for (OneToManyAssociation objectCollection : objectCollections) {
                this.appendCollectionTo(objectSpec, objectCollection);
            }
            for (ObjectAction objectAction : objectActions) {
                this.appendObjectActionInvokePath(objectSpec, objectAction);
            }
        }
    }

    void appendRestfulObjectsSupportingPathsAndDefinitions() {
        String tag = "> restful objects supporting resources";
        this.swagger.path("/", new Path().get(new Operation().tag("> restful objects supporting resources").description(Util.roSpec("5.1")).produces("application/json").produces("application/json;profile=urn:org.restfulobjects:repr-types/home-page").response(200, Generation.newResponse(Caching.NON_EXPIRING).description("OK").schema(this.newRefProperty("RestfulObjectsSupportingHomePageRepr")))));
        this.addDefinition("RestfulObjectsSupportingHomePageRepr", Generation.newModel(Util.roSpec("5.2")));
        this.swagger.path("/user", new Path().get(new Operation().tag("> restful objects supporting resources").description(Util.roSpec("6.1")).produces("application/json").produces("application/json;profile=urn:org.restfulobjects:repr-types/user").response(200, Generation.newResponse(Caching.USER_INFO).description("OK").schema(this.newRefProperty("RestfulObjectsSupportingUserRepr")))));
        this.addDefinition("RestfulObjectsSupportingUserRepr", Generation.newModel(Util.roSpec("6.2")).property("userName", (Property)Generation.stringProperty()).property("roles", (Property)Generation.arrayOfStrings()).property("links", (Property)Generation.arrayOfLinks()).required("userName").required("roles"));
        this.swagger.path("/services", new Path().get(new Operation().tag("> restful objects supporting resources").description(Util.roSpec("7.1")).produces("application/json").produces("application/json;profile=urn:org.restfulobjects:repr-types/services").response(200, Generation.newResponse(Caching.USER_INFO).description("OK").schema(this.newRefProperty("RestfulObjectsSupportingServicesRepr")))));
        this.addDefinition("RestfulObjectsSupportingServicesRepr", Generation.newModel(Util.roSpec("7.2")).property("value", (Property)Generation.arrayOfLinks()).required("userName").required("roles"));
        this.swagger.path("/version", new Path().get(new Operation().tag("> restful objects supporting resources").description(Util.roSpec("8.1")).produces("application/json").produces("application/json;profile=urn:org.restfulobjects:repr-types/RestfulObjectsSupportingServicesRepr").response(200, Generation.newResponse(Caching.NON_EXPIRING).description("OK").schema((Property)new ObjectProperty()))));
        this.swagger.addDefinition("RestfulObjectsSupportingServicesRepr", (Model)Generation.newModel(Util.roSpec("8.2")).property("specVersion", (Property)Generation.stringProperty()).property("implVersion", (Property)Generation.stringProperty()).property("optionalCapabilities", (Property)new ObjectProperty().property("blobsClobs", (Property)Generation.stringProperty()).property("deleteObjects", (Property)Generation.stringProperty()).property("domainModel", (Property)Generation.stringProperty()).property("validateOnly", (Property)Generation.stringProperty()).property("protoPersistentObjects", (Property)Generation.stringProperty())).required("userName").required("roles"));
    }

    void appendLinkModelDefinition() {
        this.swagger.addDefinition("LinkRepr", (Model)new ModelImpl().type("object").property("rel", Generation.stringProperty().description("the relationship of the resource to this referencing resource")).property("href", Generation.stringProperty().description("the hyperlink reference (URL) of the resource")).property("title", Generation.stringProperty().description("title to render")).property("method", Generation.stringPropertyEnum("GET", "POST", "PUT", "DELETE").description("HTTP verb to access")).property("type", Generation.stringProperty().description("Content-Type recognized by the resource (for HTTP Accept header)")).property("arguments", (Property)new ObjectProperty().description("Any arguments, to send as query strings or in body")).property("value", Generation.stringProperty().description("the representation of the link if followed")).required("rel").required("href").required("method"));
        this.swagger.addDefinition("HrefRepr", (Model)new ModelImpl().type("object").description("Abbreviated version of the Link resource, used primarily to reference non-value objects").property("href", Generation.stringProperty().description("the hyperlink reference (URL) of the resource")).required("href"));
    }

    void appendServicePath(ObjectSpecification objectSpec) {
        String serviceId = Generation.serviceIdFor(objectSpec);
        Path path = new Path();
        this.swagger.path(String.format("/services/%s", serviceId), path);
        String serviceModelDefinition = serviceId + "Repr";
        String tag = this.tagFor(serviceId, "> services");
        path.get(new Operation().tag(tag).description(Util.roSpec("15.1")).produces("application/json").produces("application/json;profile=urn:org.restfulobjects:repr-types/object").response(200, Generation.newResponse(Caching.TRANSACTIONAL).description("OK").schema(this.newRefProperty(serviceModelDefinition))));
        ModelImpl model = Generation.newModel(Util.roSpec("15.1.2") + ": representation of " + serviceId).property("title", (Property)Generation.stringProperty()).property("serviceId", (Property)Generation.stringProperty()._default(serviceId)).property("members", (Property)new ObjectProperty());
        this.addDefinition(serviceModelDefinition, model);
    }

    ModelImpl appendObjectPathAndModelDefinitions(ObjectSpecification objectSpec) {
        String objectType = Generation.objectTypeFor(objectSpec);
        Path path = new Path();
        this.swagger.path(String.format("/objects/%s/{objectId}", objectType), path);
        String tag = this.tagFor(objectType, null);
        Operation operation = new Operation();
        path.get(operation);
        operation.tag(tag).description(Util.roSpec("14.1")).parameter((Parameter)((PathParameter)new PathParameter().name("objectId")).type("string")).produces("application/json;profile=urn:org.apache.isis/v1").produces("application/json;profile=urn:org.apache.isis/v1;suppress=true").produces("application/json;profile=urn:org.restfulobjects:repr-types/object");
        String restfulObjectsModelDefinition = objectType + "RestfulObjectsRepr";
        String isisModelDefinition = objectType + "Repr";
        operation.response(200, Generation.newResponse(Caching.TRANSACTIONAL).description(objectType + " , if Accept: application/json;profile=urn:org.apache.isis/v1").schema(this.newRefProperty(isisModelDefinition)));
        ModelImpl isisModel = new ModelImpl();
        this.addDefinition(isisModelDefinition, isisModel);
        return isisModel;
    }

    void appendServiceActionPromptTo(ObjectProperty serviceMembers, ObjectAction action) {
        String actionId = action.getId();
        serviceMembers.property(actionId, (Property)new ObjectProperty().property("id", (Property)Generation.stringPropertyEnum(actionId)).property("memberType", (Property)Generation.stringPropertyEnum("action")).property("links", (Property)new ObjectProperty().property("rel", (Property)Generation.stringPropertyEnum(String.format("urn:org.restfulobjects:rels/details;action=%s", actionId))).property("href", (Property)Generation.stringPropertyEnum(String.format("actions/%s", actionId)))).property("method", (Property)Generation.stringPropertyEnum("GET")).property("type", (Property)Generation.stringPropertyEnum("application/json;profile=urn:org.restfulobjects:repr-types/object-action")));
    }

    void appendServiceActionInvokePath(ObjectSpecification serviceSpec, ObjectAction serviceAction) {
        String serviceId = Generation.serviceIdFor(serviceSpec);
        String actionId = serviceAction.getId();
        List<ObjectActionParameter> parameters = serviceAction.getParameters();
        Path path = new Path();
        this.swagger.path(String.format("/services/%s/actions/%s/invoke", serviceId, actionId), path);
        String tag = this.tagFor(serviceId, "> services");
        Operation invokeOperation = new Operation().tag(tag).description(Util.roSpec("19.1") + ": (invoke) resource of " + serviceId + "#" + actionId).produces("application/json;profile=urn:org.apache.isis/v1").produces("application/json;profile=urn:org.apache.isis/v1;suppress=true").produces("application/json;profile=urn:org.restfulobjects:repr-types/object").produces("application/json;profile=urn:org.restfulobjects:repr-types/action-result");
        ActionSemantics.Of semantics = serviceAction.getSemantics();
        if (semantics.isSafeInNature()) {
            path.get(invokeOperation);
            for (ObjectActionParameter parameter : parameters) {
                invokeOperation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name(parameter.getId())).description(Util.roSpec("2.9.1") + (!Strings.isNullOrEmpty((String)parameter.getDescription()) ? ": " + parameter.getDescription() : ""))).required(false)).type("string"));
            }
            if (!parameters.isEmpty()) {
                invokeOperation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("x-isis-querystring")).description(Util.roSpec("2.10") + ": all (formal) arguments as base64 encoded string")).required(false)).type("string"));
            }
        } else {
            if (semantics.isIdempotentInNature()) {
                path.put(invokeOperation);
            } else {
                path.post(invokeOperation);
            }
            ModelImpl bodyParam = new ModelImpl().type("object");
            for (ObjectActionParameter parameter : parameters) {
                StringProperty valueProperty = Generation.stringProperty();
                bodyParam.property(parameter.getId(), (Property)new ObjectProperty().property("value", (Property)valueProperty));
            }
            invokeOperation.consumes("application/json").parameter((Parameter)new BodyParameter().name("body").schema((Model)bodyParam));
        }
        invokeOperation.response(200, new Response().description(serviceId + "#" + actionId + " , if Accept: application/json;profile=urn:org.apache.isis/v1").schema(this.actionReturnTypeFor(serviceAction)));
    }

    void appendCollectionTo(ObjectSpecification objectSpec, OneToManyAssociation collection) {
        String objectType = Generation.objectTypeFor(objectSpec);
        String collectionId = collection.getId();
        Path path = new Path();
        this.swagger.path(String.format("/objects/%s/{objectId}/collections/%s", objectType, collectionId), path);
        String tag = this.tagFor(objectType, null);
        Operation collectionOperation = new Operation().tag(tag).description(Util.roSpec("17.1") + ": resource of " + objectType + "#" + collectionId).parameter((Parameter)((PathParameter)new PathParameter().name("objectId")).type("string")).produces("application/json;profile=urn:org.apache.isis/v1").produces("application/json;profile=urn:org.apache.isis/v1;suppress=true").produces("application/json;profile=urn:org.restfulobjects:repr-types/object-collection");
        path.get(collectionOperation);
        collectionOperation.response(200, new Response().description(objectType + "#" + collectionId + " , if Accept: application/json;profile=urn:org.apache.isis/v1").schema(this.modelFor(collection)));
    }

    void appendObjectActionInvokePath(ObjectSpecification objectSpec, ObjectAction objectAction) {
        String objectType = Generation.objectTypeFor(objectSpec);
        String actionId = objectAction.getId();
        List<ObjectActionParameter> parameters = objectAction.getParameters();
        Path path = new Path();
        this.swagger.path(String.format("/objects/%s/{objectId}/actions/%s/invoke", objectType, actionId), path);
        String tag = this.tagFor(objectType, null);
        Operation invokeOperation = new Operation().tag(tag).description(Util.roSpec("19.1") + ": (invoke) resource of " + objectType + "#" + actionId).parameter((Parameter)((PathParameter)new PathParameter().name("objectId")).type("string")).produces("application/json;profile=urn:org.apache.isis/v1").produces("application/json;profile=urn:org.apache.isis/v1;suppress=true").produces("application/json;profile=urn:org.restfulobjects:repr-types/action-result");
        ActionSemantics.Of semantics = objectAction.getSemantics();
        if (semantics.isSafeInNature()) {
            path.get(invokeOperation);
            for (ObjectActionParameter parameter : parameters) {
                invokeOperation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name(parameter.getId())).description(Util.roSpec("2.9.1") + (!Strings.isNullOrEmpty((String)parameter.getDescription()) ? ": " + parameter.getDescription() : ""))).required(false)).type("string"));
            }
            if (!parameters.isEmpty()) {
                invokeOperation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("x-isis-querystring")).description(Util.roSpec("2.10") + ": all (formal) arguments as base64 encoded string")).required(false)).type("string"));
            }
        } else {
            if (semantics.isIdempotentInNature()) {
                path.put(invokeOperation);
            } else {
                path.post(invokeOperation);
            }
            ModelImpl bodyParam = new ModelImpl().type("object");
            for (ObjectActionParameter parameter : parameters) {
                ObjectSpecification specification = parameter.getSpecification();
                RefProperty valueProperty = specification.isValue() ? this.modelFor(specification) : Generation.refToLinkModel();
                bodyParam.property(parameter.getId(), (Property)new ObjectProperty().property("value", (Property)valueProperty));
            }
            invokeOperation.consumes("application/json").parameter((Parameter)new BodyParameter().name("body").schema((Model)bodyParam));
        }
        invokeOperation.response(200, new Response().description(objectType + "#" + actionId).schema(this.actionReturnTypeFor(objectAction)));
    }

    void appendDefinitionsForOrphanedReferences() {
        Set<String> referencesWithoutDefinition = this.getReferencesWithoutDefinition();
        for (String reference : referencesWithoutDefinition) {
            this.swagger.addDefinition(reference, (Model)new ModelImpl());
        }
    }

    Property actionReturnTypeFor(ObjectAction objectAction) {
        ObjectSpecification elementSpec;
        ObjectSpecification specification = objectAction.getReturnType();
        TypeOfFacet typeOfFacet = objectAction.getFacet(TypeOfFacet.class);
        if (typeOfFacet != null && (elementSpec = typeOfFacet.valueSpec()) != null) {
            return this.arrayPropertyOf(elementSpec);
        }
        return this.modelFor(specification);
    }

    private Property modelFor(OneToManyAssociation collection) {
        ObjectSpecification collectionSpecification = collection.getSpecification();
        return this.arrayPropertyOf(collectionSpecification);
    }

    private Property arrayPropertyOf(ObjectSpecification objectSpecification) {
        ArrayProperty arrayProperty = new ArrayProperty();
        if (objectSpecification != null && objectSpecification.getCorrespondingClass() != Object.class) {
            arrayProperty.description("List of " + Generation.objectTypeFor(objectSpecification)).items(this.modelFor(objectSpecification));
        } else {
            arrayProperty.items((Property)new ObjectProperty());
        }
        return arrayProperty;
    }

    private Property modelFor(ObjectSpecification specification) {
        ObjectSpecification elementSpec;
        TypeOfFacet typeOfFacet;
        if (specification == null) {
            return new ObjectProperty();
        }
        Class<?> correspondingClass = specification.getCorrespondingClass();
        if (correspondingClass == Void.TYPE || correspondingClass == Void.class) {
            return new ObjectProperty();
        }
        Property property = this.valuePropertyFactory.newProperty(correspondingClass);
        if (property != null) {
            return new ObjectProperty();
        }
        if (specification.isParentedOrFreeCollection() && (typeOfFacet = specification.getFacet(TypeOfFacet.class)) != null && (elementSpec = typeOfFacet.valueSpec()) != null) {
            return this.arrayPropertyOf(elementSpec);
        }
        if (specification.getCorrespondingClass() == Object.class) {
            return new ObjectProperty();
        }
        if (specification.getCorrespondingClass() == Enum.class) {
            return new StringProperty();
        }
        return this.newRefProperty(Generation.objectTypeFor(specification) + "Repr");
    }

    void updateObjectModel(ModelImpl model, ObjectSpecification objectSpecification, List<OneToOneAssociation> objectProperties, List<OneToManyAssociation> objectCollections) {
        String objectType = Generation.objectTypeFor(objectSpecification);
        String className = objectSpecification.getFullIdentifier();
        model.type("object").description(String.format("%s (%s)", objectType, className));
        for (OneToOneAssociation objectProperty : objectProperties) {
            model.property(objectProperty.getId(), this.propertyFor(objectProperty.getSpecification()));
        }
        for (OneToManyAssociation objectCollection : objectCollections) {
            ObjectSpecification elementSpec = objectCollection.getSpecification();
            model.property(objectCollection.getId(), this.arrayPropertyOf(elementSpec));
        }
    }

    Property propertyFor(ObjectSpecification objectSpecification) {
        Property property = this.valuePropertyFactory.newProperty(objectSpecification.getCorrespondingClass());
        if (property != null) {
            return property;
        }
        return Generation.refToHrefModel();
    }

    static String roSpecForResponseOf(ObjectAction action) {
        ActionSemantics.Of semantics = action.getSemantics();
        switch (semantics) {
            case SAFE_AND_REQUEST_CACHEABLE: 
            case SAFE: {
                return "19.2";
            }
            case IDEMPOTENT: 
            case IDEMPOTENT_ARE_YOU_SURE: {
                return "19.3";
            }
        }
        return "19.4";
    }

    static ModelImpl newModel(String description) {
        return new ModelImpl().description(description).type("object").property("links", (Property)Generation.arrayOfLinks()).property("extensions", (Property)new MapProperty()).required("links").required("extensions");
    }

    static String serviceIdFor(ObjectSpecification serviceSpec) {
        Object tempServiceInstance = InstanceUtil.createInstance(serviceSpec.getCorrespondingClass(), new Object[0]);
        return Generation.serviceId(tempServiceInstance);
    }

    static String serviceId(Object object) {
        return ServiceUtil.id(object);
    }

    static String objectTypeFor(ObjectSpecification objectSpec) {
        return objectSpec.getFacet(ObjectSpecIdFacet.class).value().asString();
    }

    static StringProperty stringProperty() {
        return new StringProperty();
    }

    static StringProperty stringPropertyEnum(String ... enumValues) {
        StringProperty stringProperty = Generation.stringProperty();
        stringProperty._enum(Arrays.asList(enumValues));
        if (enumValues.length >= 1) {
            stringProperty._default(enumValues[0]);
        }
        return stringProperty;
    }

    static ArrayProperty arrayOfLinks() {
        return new ArrayProperty().items((Property)Generation.refToLinkModel());
    }

    static RefProperty refToLinkModel() {
        return new RefProperty("#/definitions/LinkRepr");
    }

    static RefProperty refToHrefModel() {
        return new RefProperty("#/definitions/HrefRepr");
    }

    static ArrayProperty arrayOfStrings() {
        return new ArrayProperty().items((Property)Generation.stringProperty());
    }

    static Response newResponse(Caching caching) {
        return Util.withCachingHeaders(new Response(), caching);
    }

    String tagFor(String str, String fallback) {
        return this.tagger.tagFor(str, fallback);
    }

    private Property newRefProperty(String model) {
        this.addSwaggerReference(model);
        return new RefProperty("#/definitions/" + model);
    }

    private void addDefinition(String key, ModelImpl model) {
        this.addSwaggerDefinition(key);
        this.swagger.addDefinition(key, (Model)model);
    }

    void addSwaggerReference(String model) {
        this.references.add(model);
    }

    void addSwaggerDefinition(String model) {
        this.definitions.add(model);
    }

    Set<String> getReferencesWithoutDefinition() {
        LinkedHashSet referencesCopy = Sets.newLinkedHashSet(this.references);
        referencesCopy.removeAll(this.definitions);
        return referencesCopy;
    }
}

