/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.repository;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.PersistFailedException;
import org.apache.isis.applib.RepositoryException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class RepositoryServiceInternalDefault
implements RepositoryService {
    private boolean autoFlush;
    @Inject
    FactoryService factoryService;
    @Inject
    WrapperFactory wrapperFactory;
    @Inject
    TransactionService transactionService;
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
        boolean disableAutoFlush = Boolean.parseBoolean(properties.get("isis.services.container.disableAutoFlush"));
        this.autoFlush = !disableAutoFlush;
    }

    @Programmatic
    public <T> T instantiate(Class<T> domainClass) {
        return (T)this.factoryService.instantiate(domainClass);
    }

    @Programmatic
    public boolean isPersistent(Object domainObject) {
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(domainObject));
        return adapter.representsPersistent();
    }

    @Programmatic
    public <T> T persist(T object) {
        if (this.isPersistent(object)) {
            return object;
        }
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(object));
        if (adapter == null) {
            throw new PersistFailedException("Object not known to framework (unable to create/obtain an adapter)");
        }
        if (adapter.isParentedCollection()) {
            return object;
        }
        if (this.isPersistent(object)) {
            throw new PersistFailedException("Object already persistent; OID=" + adapter.getOid());
        }
        this.persistenceSessionServiceInternal.makePersistent(adapter);
        return object;
    }

    @Programmatic
    public <T> T persistAndFlush(T object) {
        this.persist(object);
        this.transactionService.flushTransaction();
        return object;
    }

    @Programmatic
    public void remove(Object domainObject) {
        this.removeIfNotAlready(domainObject);
    }

    private void removeIfNotAlready(Object object) {
        if (!this.isPersistent(object)) {
            return;
        }
        if (object == null) {
            throw new IllegalArgumentException("Must specify a reference for disposing an object");
        }
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(object));
        if (!this.isPersistent(object)) {
            throw new RepositoryException("Object not persistent: " + adapter);
        }
        this.persistenceSessionServiceInternal.remove(adapter);
    }

    @Programmatic
    public void removeAndFlush(Object domainObject) {
        this.remove(domainObject);
        this.transactionService.flushTransaction();
    }

    @Programmatic
    public <T> List<T> allInstances(Class<T> type, long ... range) {
        return this.allMatches((Query<T>)new QueryFindAllInstances(type, range));
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> cls, Predicate<? super T> predicate, long ... range) {
        List<T> allInstances = this.allInstances(cls, range);
        ArrayList<T> filtered = new ArrayList<T>();
        for (T instance : allInstances) {
            if (!predicate.apply(instance)) continue;
            filtered.add(instance);
        }
        return filtered;
    }

    @Programmatic
    public <T> List<T> allMatches(Query<T> query) {
        if (this.autoFlush) {
            this.transactionService.flushTransaction();
        }
        return this.submitQuery(query);
    }

    <T> List<T> submitQuery(Query<T> query) {
        List<ObjectAdapter> allMatching = this.persistenceSessionServiceInternal.allMatchingQuery(query);
        return ObjectAdapter.Util.unwrapT(allMatching);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, Predicate<T> predicate) {
        List<T> instances = this.allMatches(type, predicate, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + predicate);
        }
        return RepositoryServiceInternalDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Query<T> query) {
        List<T> instances = this.allMatches(query);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance for query:" + query.getDescription());
        }
        return RepositoryServiceInternalDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T firstMatch(Class<T> cls, Predicate<T> predicate) {
        List<T> allInstances = this.allInstances(cls, new long[0]);
        for (T instance : allInstances) {
            if (!predicate.apply(instance)) continue;
            return instance;
        }
        return null;
    }

    @Programmatic
    public <T> T firstMatch(Query<T> query) {
        if (this.autoFlush) {
            this.transactionService.flushTransaction();
        }
        ObjectAdapter firstMatching = this.persistenceSessionServiceInternal.firstMatchingQuery(query);
        return (T)ObjectAdapter.Util.unwrap(firstMatching);
    }

    private static <T> T firstInstanceElseNull(List<T> instances) {
        return instances.size() == 0 ? null : (T)instances.get(0);
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }
}

