/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.metamodel;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.PublishedAction;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.applib.services.metamodel.MetaModelService6;
import org.apache.isis.applib.spec.Specification;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneActionParameter;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoNamedQuery;
import org.apache.isis.schema.metamodel.v1.Action;
import org.apache.isis.schema.metamodel.v1.DomainClassDto;
import org.apache.isis.schema.metamodel.v1.Facet;
import org.apache.isis.schema.metamodel.v1.FacetAttr;
import org.apache.isis.schema.metamodel.v1.FacetHolder;
import org.apache.isis.schema.metamodel.v1.Member;
import org.apache.isis.schema.metamodel.v1.MetamodelDto;
import org.apache.isis.schema.metamodel.v1.Param;
import org.apache.isis.schema.metamodel.v1.Property;
import org.apache.isis.schema.metamodel.v1.ScalarParam;
import org.apache.isis.schema.metamodel.v1.VectorParam;
import org.apache.isis.schema.utils.CommonDtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaModelExporter {
    private static final Logger LOG = LoggerFactory.getLogger(MetaModelExporter.class);
    SpecificationLoader specificationLookup;

    public MetaModelExporter(SpecificationLoader specificationLookup) {
        this.specificationLookup = specificationLookup;
    }

    MetamodelDto exportMetaModel(MetaModelService6.Config config) {
        MetamodelDto metamodelDto = new MetamodelDto();
        HashMap domainClassByObjectSpec = Maps.newHashMap();
        for (ObjectSpecification specification : this.specificationLookup.allSpecifications()) {
            DomainClassDto domainClassType = this.asXsdType(specification, config);
            domainClassByObjectSpec.put(specification, domainClassType);
        }
        ArrayList processed = Lists.newArrayList();
        List<ObjectSpecification> toProcess = MetaModelExporter.remaining(domainClassByObjectSpec.keySet(), processed);
        while (!toProcess.isEmpty()) {
            for (ObjectSpecification specification : toProcess) {
                this.addFacetsAndMembersTo(specification, domainClassByObjectSpec, config);
            }
            processed.addAll(toProcess);
            toProcess = MetaModelExporter.remaining(domainClassByObjectSpec.keySet(), processed);
        }
        HashMap objectSpecificationByDomainClassId = Maps.newHashMap();
        ArrayList buf = Lists.newArrayList();
        for (Map.Entry entry : domainClassByObjectSpec.entrySet()) {
            ObjectSpecification objectSpecification = (ObjectSpecification)entry.getKey();
            DomainClassDto domainClassDto = (DomainClassDto)entry.getValue();
            String id = domainClassDto.getId();
            ObjectSpecification existing = (ObjectSpecification)objectSpecificationByDomainClassId.get(id);
            if (existing != null) {
                if (existing.getCorrespondingClass().isEnum()) continue;
                buf.add(String.format("%s mapped to %s and %s", id, existing, objectSpecification));
                continue;
            }
            objectSpecificationByDomainClassId.put(id, objectSpecification);
        }
        if (buf.size() > 0) {
            throw new IllegalStateException(Joiner.on((String)"\n").join((Iterable)buf));
        }
        for (ObjectSpecification objectSpecification : Lists.newArrayList(domainClassByObjectSpec.keySet())) {
            if (this.shouldIgnore(config, objectSpecification)) continue;
            metamodelDto.getDomainClassDto().add(domainClassByObjectSpec.get(objectSpecification));
        }
        MetaModelExporter.sortDomainClasses(metamodelDto.getDomainClassDto());
        return metamodelDto;
    }

    private boolean shouldIgnore(MetaModelService6.Config config, ObjectSpecification specification) {
        return this.notInPackagePrefixes(specification, config) || config.isIgnoreMixins() && specification.isMixin() || config.isIgnoreInterfaces() && specification.getCorrespondingClass().isInterface() || config.isIgnoreAbstractClasses() && Modifier.isAbstract(specification.getCorrespondingClass().getModifiers()) || config.isIgnoreBuiltInValueTypes() && this.isValueType(specification);
    }

    private static <T> List<T> remaining(Collection<T> processed, Collection<T> other) {
        ArrayList x = Lists.newArrayList(processed);
        x.removeAll(other);
        return x;
    }

    private boolean notInPackagePrefixes(ObjectSpecification specification, MetaModelService6.Config config) {
        return !this.inPackagePrefixes(specification, config);
    }

    private boolean inPackagePrefixes(ObjectSpecification specification, MetaModelService6.Config config) {
        String canonicalName = specification.getCorrespondingClass().getCanonicalName();
        for (String s : config.getPackagePrefixes()) {
            if (!canonicalName.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private DomainClassDto asXsdType(ObjectSpecification specification, MetaModelService6.Config config) {
        DomainClassDto domainClass = new DomainClassDto();
        domainClass.setId(specification.getFullIdentifier());
        if (specification.isService()) {
            domainClass.setService(Boolean.valueOf(true));
        }
        return domainClass;
    }

    private void addFacetsAndMembersTo(ObjectSpecification specification, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        DomainClassDto domainClass = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        if (domainClass.getFacets() == null) {
            domainClass.setFacets(new FacetHolder.Facets());
        }
        this.addFacets(specification, domainClass.getFacets(), config);
        if (specification.isValueOrIsParented() || this.isEnum(specification)) {
            return;
        }
        if (specification.isService()) {
            if (!this.hasNatureOfServiceOfDomain(specification)) {
                this.addActions(specification, domainClassByObjectSpec, config);
            }
        } else {
            this.addProperties(specification, domainClassByObjectSpec, config);
            this.addCollections(specification, domainClassByObjectSpec, config);
            this.addActions(specification, domainClassByObjectSpec, config);
        }
    }

    private boolean isEnum(ObjectSpecification specification) {
        return specification.getCorrespondingClass().isEnum();
    }

    private boolean hasNatureOfServiceOfDomain(ObjectSpecification specification) {
        DomainServiceFacet domainServiceFacet = specification.getFacet(DomainServiceFacet.class);
        return domainServiceFacet != null && domainServiceFacet.getNatureOfService() == NatureOfService.DOMAIN;
    }

    private void addProperties(ObjectSpecification specification, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        DomainClassDto domainClass = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        List<ObjectAssociation> oneToOneAssociations = specification.getAssociations(Contributed.INCLUDED, ObjectAssociation.Filters.PROPERTIES);
        if (domainClass.getProperties() == null) {
            domainClass.setProperties(new DomainClassDto.Properties());
        }
        List properties = domainClass.getProperties().getProp();
        for (ObjectAssociation association : oneToOneAssociations) {
            OneToOneAssociation otoa = (OneToOneAssociation)association;
            properties.add(this.asXsdType(otoa, domainClassByObjectSpec, config));
        }
        this.sortMembers(properties);
    }

    private void addCollections(ObjectSpecification specification, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        DomainClassDto domainClass = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        List<ObjectAssociation> oneToManyAssociations = specification.getAssociations(Contributed.INCLUDED, ObjectAssociation.Filters.COLLECTIONS);
        if (domainClass.getCollections() == null) {
            domainClass.setCollections(new DomainClassDto.Collections());
        }
        List collections = domainClass.getCollections().getColl();
        for (ObjectAssociation association : oneToManyAssociations) {
            OneToManyAssociation otma = (OneToManyAssociation)association;
            collections.add(this.asXsdType(otma, domainClassByObjectSpec, config));
        }
        this.sortMembers(collections);
    }

    private void addActions(ObjectSpecification specification, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        DomainClassDto domainClass = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        List<ObjectAction> objectActions = specification.getObjectActions(Contributed.INCLUDED);
        if (domainClass.getActions() == null) {
            domainClass.setActions(new DomainClassDto.Actions());
        }
        List actions = domainClass.getActions().getAct();
        for (ObjectAction action : objectActions) {
            actions.add(this.asXsdType(action, domainClassByObjectSpec, config));
        }
        this.sortMembers(actions);
    }

    private Property asXsdType(OneToOneAssociation otoa, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        Property propertyType = new Property();
        propertyType.setId(otoa.getId());
        propertyType.setFacets(new FacetHolder.Facets());
        ObjectSpecification specification = otoa.getSpecification();
        DomainClassDto value = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        propertyType.setType((Object)value);
        this.addFacets(otoa, propertyType.getFacets(), config);
        return propertyType;
    }

    private org.apache.isis.schema.metamodel.v1.Collection asXsdType(OneToManyAssociation otoa, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        org.apache.isis.schema.metamodel.v1.Collection collectionType = new org.apache.isis.schema.metamodel.v1.Collection();
        collectionType.setId(otoa.getId());
        collectionType.setFacets(new FacetHolder.Facets());
        ObjectSpecification specification = otoa.getSpecification();
        DomainClassDto value = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        collectionType.setType((Object)value);
        this.addFacets(otoa, collectionType.getFacets(), config);
        return collectionType;
    }

    private Action asXsdType(ObjectAction oa, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        Action actionType = new Action();
        actionType.setId(oa.getId());
        actionType.setFacets(new FacetHolder.Facets());
        actionType.setParams(new Action.Params());
        ObjectSpecification specification = oa.getReturnType();
        DomainClassDto value = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        actionType.setReturnType((Object)value);
        this.addFacets(oa, actionType.getFacets(), config);
        List<ObjectActionParameter> parameters = oa.getParameters();
        List params = actionType.getParams().getParam();
        for (ObjectActionParameter parameter : parameters) {
            params.add(this.asXsdType(parameter, domainClassByObjectSpec, config));
        }
        return actionType;
    }

    private DomainClassDto lookupDomainClass(ObjectSpecification specification, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        DomainClassDto value = domainClassByObjectSpec.get(specification);
        if (value == null) {
            DomainClassDto domainClass = this.asXsdType(specification, config);
            domainClassByObjectSpec.put(specification, domainClass);
            value = domainClass;
        }
        return value;
    }

    private Param asXsdType(ObjectActionParameter parameter, Map<ObjectSpecification, DomainClassDto> domainClassByObjectSpec, MetaModelService6.Config config) {
        ScalarParam parameterType = parameter instanceof OneToOneActionParameter ? new ScalarParam() : new VectorParam();
        parameterType.setId(parameter.getId());
        parameterType.setFacets(new FacetHolder.Facets());
        ObjectSpecification specification = parameter.getSpecification();
        DomainClassDto value = this.lookupDomainClass(specification, domainClassByObjectSpec, config);
        parameterType.setType((Object)value);
        this.addFacets(parameter, parameterType.getFacets(), config);
        return parameterType;
    }

    private void addFacets(FacetHolder facetHolder, FacetHolder.Facets facets, MetaModelService6.Config config) {
        Class<? extends org.apache.isis.core.metamodel.facetapi.Facet>[] facetTypes;
        for (Class<? extends org.apache.isis.core.metamodel.facetapi.Facet> facetType : facetTypes = facetHolder.getFacetTypes()) {
            org.apache.isis.core.metamodel.facetapi.Facet facet = facetHolder.getFacet(facetType);
            if (facet.isNoop() && config.isIgnoreNoop()) continue;
            facets.getFacet().add(this.asXsdType(facet, config));
        }
        this.sortFacets(facets.getFacet());
    }

    private Facet asXsdType(org.apache.isis.core.metamodel.facetapi.Facet facet, MetaModelService6.Config config) {
        Facet facetType = new Facet();
        facetType.setId(facet.facetType().getCanonicalName());
        facetType.setFqcn(facet.getClass().getCanonicalName());
        this.addFacetAttributes(facet, facetType, config);
        return facetType;
    }

    private void addFacetAttributes(org.apache.isis.core.metamodel.facetapi.Facet facet, Facet facetType, MetaModelService6.Config config) {
        TreeMap attributeMap = Maps.newTreeMap();
        facet.appendAttributesTo(attributeMap);
        for (String key : attributeMap.keySet()) {
            Object attributeObj = attributeMap.get(key);
            if (attributeObj == null) continue;
            String str = this.asStr(attributeObj);
            this.addAttribute(facetType, key, str);
        }
        this.sortFacetAttributes(facetType.getAttr());
    }

    private void addAttribute(Facet facetType, String key, String str) {
        if (str == null) {
            return;
        }
        FacetAttr attributeDto = new FacetAttr();
        attributeDto.setName(key);
        attributeDto.setValue(str);
        facetType.getAttr().add(attributeDto);
    }

    private void sortFacetAttributes(List<FacetAttr> attributes) {
        Collections.sort(attributes, new Comparator<FacetAttr>(){

            @Override
            public int compare(FacetAttr o1, FacetAttr o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private static void sortDomainClasses(List<DomainClassDto> specifications) {
        Collections.sort(specifications, new Comparator<DomainClassDto>(){

            @Override
            public int compare(DomainClassDto o1, DomainClassDto o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    private void sortMembers(List<? extends Member> members) {
        Collections.sort(members, new Comparator<Member>(){

            @Override
            public int compare(Member o1, Member o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    private void sortFacets(List<Facet> facets) {
        Collections.sort(facets, new Comparator<Facet>(){

            @Override
            public int compare(Facet o1, Facet o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    private boolean isValueType(ObjectSpecification specification) {
        return CommonDtoUtils.VALUE_TYPES.contains(specification.getCorrespondingClass());
    }

    private String asStr(Object attributeObj) {
        String str = attributeObj instanceof Method ? this.asStr((Method)attributeObj) : (attributeObj instanceof String ? this.asStr((String)attributeObj) : (attributeObj instanceof Enum ? this.asStr((Enum)attributeObj) : (attributeObj instanceof Class ? this.asStr((Class)attributeObj) : (attributeObj instanceof Specification ? this.asStr((Specification)attributeObj) : (attributeObj instanceof org.apache.isis.core.metamodel.facetapi.Facet ? this.asStr((org.apache.isis.core.metamodel.facetapi.Facet)attributeObj) : (attributeObj instanceof JdoNamedQuery ? this.asStr((JdoNamedQuery)attributeObj) : (attributeObj instanceof Pattern ? this.asStr((Pattern)attributeObj) : (attributeObj instanceof PublishedObject.PayloadFactory ? this.asStr((PublishedObject.PayloadFactory)attributeObj) : (attributeObj instanceof PublishedAction.PayloadFactory ? this.asStr((PublishedAction.PayloadFactory)attributeObj) : (attributeObj instanceof CommandDtoProcessor ? this.asStr((CommandDtoProcessor)attributeObj) : (attributeObj instanceof ObjectSpecification ? this.asStr((ObjectSpecification)attributeObj) : (attributeObj instanceof ObjectMember ? this.asStr((ObjectMember)attributeObj) : (attributeObj instanceof List ? this.asStr((List)attributeObj) : (attributeObj instanceof Object[] ? this.asStr((Object[])attributeObj) : "" + attributeObj))))))))))))));
        return str;
    }

    private String asStr(String attributeObj) {
        return Strings.emptyToNull((String)attributeObj);
    }

    private String asStr(Specification attributeObj) {
        return attributeObj.getClass().getName();
    }

    private String asStr(ObjectSpecification attributeObj) {
        return attributeObj.getFullIdentifier();
    }

    private String asStr(JdoNamedQuery attributeObj) {
        return attributeObj.getName();
    }

    private String asStr(CommandDtoProcessor attributeObj) {
        return attributeObj.getClass().getName();
    }

    private String asStr(PublishedAction.PayloadFactory attributeObj) {
        return attributeObj.getClass().getName();
    }

    private String asStr(PublishedObject.PayloadFactory attributeObj) {
        return attributeObj.getClass().getName();
    }

    private String asStr(Pattern attributeObj) {
        return attributeObj.pattern();
    }

    private String asStr(org.apache.isis.core.metamodel.facetapi.Facet attributeObj) {
        return attributeObj.getClass().getName();
    }

    private String asStr(ObjectMember attributeObj) {
        return attributeObj.getId();
    }

    private String asStr(Class attributeObj) {
        return attributeObj.getCanonicalName();
    }

    private String asStr(Enum attributeObj) {
        return attributeObj.name();
    }

    private String asStr(Method attributeObj) {
        return attributeObj.toGenericString();
    }

    private String asStr(Object[] list) {
        if (list.length == 0) {
            return null;
        }
        ArrayList strings = Lists.newArrayList();
        for (Object o : list) {
            String s = this.asStr(o);
            strings.add(s);
        }
        return Joiner.on((String)";").join((Iterable)strings);
    }

    private String asStr(List<?> list) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList strings = Lists.newArrayList();
        for (Object o : list) {
            String s = this.asStr(o);
            strings.add(s);
        }
        return Joiner.on((String)";").join((Iterable)strings);
    }
}

