/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.jdosupport;

import java.io.IOException;
import javax.inject.Inject;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.metadata.TypeMetadata;
import javax.xml.bind.JAXBException;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Contributed;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.metamodel.services.jdosupport.Util;
import org.datanucleus.enhancement.Persistable;

@Mixin(method="act")
public class Persistable_downloadJdoMetadata {
    private final Persistable persistable;
    @Inject
    IsisJdoSupport jdoSupport;

    public Persistable_downloadJdoMetadata(Persistable persistable) {
        this.persistable = persistable;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(contributed=Contributed.AS_ACTION, cssClassFa="fa-download", position=ActionLayout.Position.PANEL_DROPDOWN)
    @MemberOrder(name="datanucleusIdLong", sequence="710.1")
    public Clob act(@ParameterLayout(named="File name") String fileName) throws JAXBException, IOException {
        Class<?> objClass = this.persistable.getClass();
        String objClassName = objClass.getName();
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(objClassName);
        String xml = metadata.toString();
        return new Clob(Util.withSuffix(fileName, "jdo"), "text/xml", (CharSequence)xml);
    }

    public String default0Act() {
        return Util.withSuffix(this.persistable.getClass().getName(), "jdo");
    }

    PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoSupport.getJdoPersistenceManager().getPersistenceManagerFactory();
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<Persistable_downloadJdoMetadata> {
    }
}

