/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.config.ConfigurationProperty;
import org.apache.isis.applib.services.config.ConfigurationService;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ConfigurationServiceDefault
implements ConfigurationService {
    private Map<String, String> properties;
    @Inject
    ConfigurationServiceInternal configurationServiceInternal;

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
        this.properties = properties;
    }

    @Programmatic
    public Set<ConfigurationProperty> allProperties() {
        TreeSet<ConfigurationProperty> kv = new TreeSet<ConfigurationProperty>();
        for (Map.Entry<String, String> propertyPair : this.properties.entrySet()) {
            kv.add(new ConfigurationProperty(propertyPair.getKey(), propertyPair.getValue()));
        }
        return kv;
    }

    @Programmatic
    public String getProperty(String name) {
        return this.configurationServiceInternal.getProperty(name);
    }

    @Programmatic
    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value == null ? defaultValue : value;
    }

    @Programmatic
    public List<String> getPropertyNames() {
        return this.configurationServiceInternal.getPropertyNames();
    }
}

