/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.bookmarks;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkHolder;
import org.apache.isis.applib.services.bookmark.BookmarkService2;
import org.apache.isis.applib.services.registry.ServiceRegistry2;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class BookmarkServiceInternalDefault
implements BookmarkService2 {
    private Map<String, Object> servicesByClassName;
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;
    @Inject
    private WrapperFactory wrapperFactory;
    @Inject
    ServiceRegistry2 serviceRegistry2;

    @Programmatic
    public Object lookup(BookmarkHolder bookmarkHolder, BookmarkService2.FieldResetPolicy fieldResetPolicy) {
        Bookmark bookmark = bookmarkHolder.bookmark();
        return bookmark != null ? this.lookup(bookmark, fieldResetPolicy) : null;
    }

    @Programmatic
    public Object lookup(BookmarkHolder bookmarkHolder) {
        return this.lookup(bookmarkHolder, BookmarkService2.FieldResetPolicy.RESET);
    }

    private Object lookupInternal(Bookmark bookmark, BookmarkService2.FieldResetPolicy fieldResetPolicy) {
        if (bookmark == null) {
            return null;
        }
        try {
            return this.persistenceSessionServiceInternal.lookup(bookmark, fieldResetPolicy);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    @Programmatic
    public Object lookup(Bookmark bookmark, BookmarkService2.FieldResetPolicy fieldResetPolicy) {
        if (bookmark == null) {
            return null;
        }
        String objectType = bookmark.getObjectType();
        Object service = this.lookupService(objectType);
        if (service != null) {
            return service;
        }
        return this.lookupInternal(bookmark, fieldResetPolicy);
    }

    @Programmatic
    public Object lookup(Bookmark bookmark) {
        return this.lookup(bookmark, BookmarkService2.FieldResetPolicy.RESET);
    }

    @Programmatic
    public <T> T lookup(Bookmark bookmark, BookmarkService2.FieldResetPolicy fieldResetPolicy, Class<T> cls) {
        return (T)this.lookup(bookmark, fieldResetPolicy);
    }

    @Programmatic
    public <T> T lookup(Bookmark bookmark, Class<T> cls) {
        return this.lookup(bookmark, BookmarkService2.FieldResetPolicy.RESET, cls);
    }

    @Programmatic
    public Bookmark bookmarkFor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        return this.persistenceSessionServiceInternal.bookmarkFor(this.unwrapped(domainObject));
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    @Programmatic
    public Bookmark bookmarkFor(Class<?> cls, String identifier) {
        return this.persistenceSessionServiceInternal.bookmarkFor(cls, identifier);
    }

    private Object lookupService(String className) {
        this.cacheServicesByClassNameIfNecessary();
        return this.servicesByClassName.get(className);
    }

    private void cacheServicesByClassNameIfNecessary() {
        if (this.servicesByClassName == null) {
            HashMap servicesByClassName = Maps.newHashMap();
            List registeredServices = this.serviceRegistry2.getRegisteredServices();
            for (Object registeredService : registeredServices) {
                String serviceClassName = registeredService.getClass().getName();
                servicesByClassName.put(serviceClassName, registeredService);
            }
            this.servicesByClassName = servicesByClassName;
        }
    }
}

