/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.appfeat;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.isis.applib.services.appfeat.ApplicationMemberType;
import org.apache.isis.applib.services.config.ConfigurationService;
import org.apache.isis.applib.services.registry.ServiceRegistry2;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeature;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureFactory;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;

@DomainService(nature=NatureOfService.DOMAIN, repositoryFor=ApplicationFeature.class, menuOrder="2147483647")
public class ApplicationFeatureRepositoryDefault
implements ApplicationFeatureRepository {
    SortedMap<ApplicationFeatureId, ApplicationFeature> packageFeatures = Maps.newTreeMap();
    private final SortedMap<ApplicationFeatureId, ApplicationFeature> classFeatures = Maps.newTreeMap();
    private final SortedMap<ApplicationFeatureId, ApplicationFeature> memberFeatures = Maps.newTreeMap();
    private final SortedMap<ApplicationFeatureId, ApplicationFeature> propertyFeatures = Maps.newTreeMap();
    private final SortedMap<ApplicationFeatureId, ApplicationFeature> collectionFeatures = Maps.newTreeMap();
    private final SortedMap<ApplicationFeatureId, ApplicationFeature> actionFeatures = Maps.newTreeMap();
    private static final String KEY = "isis.services.applicationFeatures.init";
    private InitializationState initializationState = InitializationState.NOT_INITIALIZED;
    @Inject
    ServiceRegistry2 serviceRegistry;
    @Inject
    DomainObjectContainer container;
    @Inject
    ConfigurationService configurationService;
    @Inject
    SpecificationLoader specificationLoader;
    @Inject
    ApplicationFeatureFactory applicationFeatureFactory;

    @Programmatic
    @PostConstruct
    public void init() {
        if (this.isEagerInitialize()) {
            this.initializeIfRequired();
        }
    }

    private boolean isEagerInitialize() {
        String configuredValue = this.configurationService.getProperty(KEY);
        return "eager".equalsIgnoreCase(configuredValue) || "eagerly".equalsIgnoreCase(configuredValue);
    }

    private synchronized void initializeIfRequired() {
        if (this.initializationState == InitializationState.INITIALIZED) {
            return;
        }
        this.initializationState = InitializationState.INITIALIZED;
        Collection<ObjectSpecification> specifications = this.primeMetaModel();
        this.createApplicationFeaturesFor(specifications);
    }

    private Collection<ObjectSpecification> primeMetaModel() {
        List services = this.serviceRegistry.getRegisteredServices();
        for (Object service : services) {
            this.specificationLoader.loadSpecification(service.getClass());
        }
        return this.specificationLoader.allSpecifications();
    }

    private void createApplicationFeaturesFor(Collection<ObjectSpecification> specifications) {
        ArrayList objectSpecifications = Lists.newArrayList(specifications);
        for (ObjectSpecification spec : objectSpecifications) {
            this.createApplicationFeaturesFor(spec);
        }
    }

    void createApplicationFeaturesFor(ObjectSpecification spec) {
        if (this.exclude(spec)) {
            return;
        }
        List<ObjectAssociation> properties = spec.getAssociations(Contributed.INCLUDED, ObjectAssociation.Filters.PROPERTIES);
        List<ObjectAssociation> collections = spec.getAssociations(Contributed.INCLUDED, ObjectAssociation.Filters.COLLECTIONS);
        List<ObjectAction> actions = spec.getObjectActions(Contributed.INCLUDED);
        if (properties.isEmpty() && collections.isEmpty() && actions.isEmpty()) {
            return;
        }
        String fullIdentifier = spec.getFullIdentifier();
        ApplicationFeatureId classFeatureId = ApplicationFeatureId.newClass(fullIdentifier);
        ApplicationFeature classFeature = this.newFeature(classFeatureId);
        this.classFeatures.put(classFeatureId, classFeature);
        boolean addedMembers = false;
        for (ObjectAssociation property : properties) {
            Class<?> returnType = ApplicationFeatureRepositoryDefault.correspondingClassFor(property.getSpecification());
            Integer maxLength = returnType == String.class ? ApplicationFeatureRepositoryDefault.valueOf(property, MaxLengthFacet.class) : null;
            Integer typicalLength = returnType == String.class ? ApplicationFeatureRepositoryDefault.valueOf(property, TypicalLengthFacet.class) : null;
            boolean derived = !property.containsDoOpFacet(PropertySetterFacet.class);
            boolean contributed = property instanceof ContributeeMember;
            addedMembers = this.newProperty(classFeatureId, property, returnType, contributed, maxLength, typicalLength, derived) || addedMembers;
        }
        for (ObjectAssociation collection : collections) {
            boolean derived = !collection.containsDoOpFacet(CollectionAddToFacet.class) && !collection.containsDoOpFacet(CollectionRemoveFromFacet.class);
            Class<?> elementType = ApplicationFeatureRepositoryDefault.correspondingClassFor(collection.getSpecification());
            boolean contributed = collection instanceof ContributeeMember;
            addedMembers = this.newCollection(classFeatureId, collection, elementType, contributed, derived) || addedMembers;
        }
        for (ObjectAction action : actions) {
            SemanticsOf actionSemantics;
            boolean contributed;
            Class<?> returnType;
            addedMembers = this.newAction(classFeatureId, action, returnType = ApplicationFeatureRepositoryDefault.correspondingClassFor(action.getReturnType()), contributed = action instanceof ContributeeMember, actionSemantics = SemanticsOf.from((ActionSemantics.Of)action.getSemantics())) || addedMembers;
        }
        if (!addedMembers) {
            this.classFeatures.remove(classFeatureId);
            return;
        }
        ApplicationFeatureId classParentPackageId = this.addClassParent(classFeatureId);
        this.addParents(classParentPackageId);
    }

    private static Class<?> correspondingClassFor(ObjectSpecification objectSpec) {
        return objectSpec != null ? objectSpec.getCorrespondingClass() : null;
    }

    private static Integer valueOf(FacetHolder facetHolder, Class<? extends SingleIntValueFacet> cls) {
        SingleIntValueFacet facet = facetHolder.getFacet(cls);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }

    ApplicationFeatureId addClassParent(ApplicationFeatureId classFeatureId) {
        ApplicationFeatureId parentPackageId = classFeatureId.getParentPackageId();
        ApplicationFeature parentPackage = this.findPackageElseCreate(parentPackageId);
        parentPackage.addToContents(classFeatureId);
        return parentPackageId;
    }

    void addParents(ApplicationFeatureId classOrPackageId) {
        ApplicationFeatureId parentPackageId = classOrPackageId.getParentPackageId();
        if (parentPackageId == null) {
            return;
        }
        ApplicationFeature parentPackage = this.findPackageElseCreate(parentPackageId);
        parentPackage.addToContents(classOrPackageId);
        this.addParents(parentPackageId);
    }

    private ApplicationFeature findPackageElseCreate(ApplicationFeatureId parentPackageId) {
        ApplicationFeature parentPackage = this.findPackage(parentPackageId);
        if (parentPackage == null) {
            parentPackage = this.newPackage(parentPackageId);
        }
        return parentPackage;
    }

    private ApplicationFeature newPackage(ApplicationFeatureId packageId) {
        ApplicationFeature parentPackage = this.newFeature(packageId);
        this.packageFeatures.put(packageId, parentPackage);
        return parentPackage;
    }

    private boolean newProperty(ApplicationFeatureId classFeatureId, ObjectMember objectMember, Class<?> returnType, boolean contributed, Integer maxLength, Integer typicalLength, boolean derived) {
        return this.newMember(classFeatureId, objectMember, ApplicationMemberType.PROPERTY, returnType, contributed, (Boolean)derived, maxLength, typicalLength, null);
    }

    private boolean newCollection(ApplicationFeatureId classFeatureId, ObjectMember objectMember, Class<?> returnType, boolean contributed, boolean derived) {
        return this.newMember(classFeatureId, objectMember, ApplicationMemberType.COLLECTION, returnType, contributed, (Boolean)derived, null, null, null);
    }

    private boolean newAction(ApplicationFeatureId classFeatureId, ObjectMember objectMember, Class<?> returnType, boolean contributed, SemanticsOf actionSemantics) {
        return this.newMember(classFeatureId, objectMember, ApplicationMemberType.ACTION, returnType, contributed, null, null, null, actionSemantics);
    }

    private boolean newMember(ApplicationFeatureId classFeatureId, ObjectMember objectMember, ApplicationMemberType memberType, Class<?> returnType, boolean contributed, Boolean derived, Integer maxLength, Integer typicalLength, SemanticsOf actionSemantics) {
        if (objectMember.isAlwaysHidden()) {
            return false;
        }
        this.newMember(classFeatureId, objectMember.getId(), memberType, returnType, contributed, derived, maxLength, typicalLength, actionSemantics);
        return true;
    }

    private void newMember(ApplicationFeatureId classFeatureId, String memberId, ApplicationMemberType memberType, Class<?> returnType, boolean contributed, Boolean derived, Integer maxLength, Integer typicalLength, SemanticsOf actionSemantics) {
        ApplicationFeatureId featureId = ApplicationFeatureId.newMember(classFeatureId.getFullyQualifiedName(), memberId);
        ApplicationFeature memberFeature = this.newFeature(featureId);
        memberFeature.setMemberType(memberType);
        memberFeature.setReturnTypeName(returnType != null ? returnType.getSimpleName() : null);
        memberFeature.setContributed(contributed);
        memberFeature.setDerived(derived);
        memberFeature.setPropertyMaxLength(maxLength);
        memberFeature.setPropertyTypicalLength(typicalLength);
        memberFeature.setActionSemantics(actionSemantics);
        this.memberFeatures.put(featureId, memberFeature);
        this.featuresMapFor(memberType).put(featureId, memberFeature);
        ApplicationFeature classFeature = this.findClass(classFeatureId);
        classFeature.addToMembers(featureId, memberType);
    }

    private SortedMap<ApplicationFeatureId, ApplicationFeature> featuresMapFor(ApplicationMemberType memberType) {
        switch (memberType) {
            case PROPERTY: {
                return this.propertyFeatures;
            }
            case COLLECTION: {
                return this.collectionFeatures;
            }
        }
        return this.actionFeatures;
    }

    private ApplicationFeature newFeature(ApplicationFeatureId featureId) {
        ApplicationFeature feature = this.applicationFeatureFactory.newApplicationFeature();
        feature.setFeatureId(featureId);
        return feature;
    }

    protected boolean exclude(ObjectSpecification spec) {
        return spec.isAbstract() || this.isBuiltIn(spec) || this.isHidden(spec) || this.isFixtureScript(spec) || this.isSuperClassOfService(spec);
    }

    private boolean isFixtureScript(ObjectSpecification spec) {
        return FixtureScript.class.isAssignableFrom(spec.getCorrespondingClass());
    }

    private boolean isSuperClassOfService(ObjectSpecification spec) {
        Class<?> serviceClass;
        List registeredServices = this.serviceRegistry.getRegisteredServices();
        Class<?> specClass = spec.getCorrespondingClass();
        boolean serviceCls = false;
        for (Object registeredService : registeredServices) {
            serviceClass = registeredService.getClass();
            if (!specClass.isAssignableFrom(serviceClass)) continue;
            serviceCls = true;
        }
        if (!serviceCls) {
            return false;
        }
        for (Object registeredService : registeredServices) {
            serviceClass = registeredService.getClass();
            if (!serviceClass.isAssignableFrom(specClass)) continue;
            return false;
        }
        return true;
    }

    protected boolean isHidden(ObjectSpecification spec) {
        HiddenFacet facet = spec.getFacet(HiddenFacet.class);
        return facet != null && !facet.isNoop() && (facet.where() == Where.EVERYWHERE || facet.where() == Where.ANYWHERE) && facet.when() == When.ALWAYS;
    }

    protected boolean isBuiltIn(ObjectSpecification spec) {
        String className = spec.getFullIdentifier();
        return className.startsWith("java") || className.startsWith("org.joda");
    }

    @Programmatic
    public ApplicationFeature findFeature(ApplicationFeatureId featureId) {
        this.initializeIfRequired();
        switch (featureId.getType()) {
            case PACKAGE: {
                return this.findPackage(featureId);
            }
            case CLASS: {
                return this.findClass(featureId);
            }
            case MEMBER: {
                return this.findMember(featureId);
            }
        }
        throw new IllegalArgumentException("Feature has unknown feature type " + (Object)((Object)featureId.getType()));
    }

    @Programmatic
    public ApplicationFeature findPackage(ApplicationFeatureId featureId) {
        this.initializeIfRequired();
        return (ApplicationFeature)this.packageFeatures.get(featureId);
    }

    @Programmatic
    public ApplicationFeature findClass(ApplicationFeatureId featureId) {
        this.initializeIfRequired();
        return (ApplicationFeature)this.classFeatures.get(featureId);
    }

    @Programmatic
    public ApplicationFeature findMember(ApplicationFeatureId featureId) {
        this.initializeIfRequired();
        return (ApplicationFeature)this.memberFeatures.get(featureId);
    }

    @Programmatic
    public Collection<ApplicationFeature> allFeatures(ApplicationFeatureType featureType) {
        this.initializeIfRequired();
        if (featureType == null) {
            return Collections.emptyList();
        }
        switch (featureType) {
            case PACKAGE: {
                return this.allPackages();
            }
            case CLASS: {
                return this.allClasses();
            }
            case MEMBER: {
                return this.allMembers();
            }
        }
        throw new IllegalArgumentException("Unknown feature type " + (Object)((Object)featureType));
    }

    @Programmatic
    public Collection<ApplicationFeature> allPackages() {
        this.initializeIfRequired();
        return this.packageFeatures.values();
    }

    @Programmatic
    public Collection<ApplicationFeature> allClasses() {
        this.initializeIfRequired();
        return this.classFeatures.values();
    }

    @Programmatic
    public Collection<ApplicationFeature> allMembers() {
        this.initializeIfRequired();
        return this.memberFeatures.values();
    }

    @Programmatic
    public Collection<ApplicationFeature> allProperties() {
        this.initializeIfRequired();
        return this.propertyFeatures.values();
    }

    @Programmatic
    public Collection<ApplicationFeature> allCollections() {
        this.initializeIfRequired();
        return this.collectionFeatures.values();
    }

    @Programmatic
    public Collection<ApplicationFeature> allActions() {
        this.initializeIfRequired();
        return this.actionFeatures.values();
    }

    @Programmatic
    public List<String> packageNames() {
        this.initializeIfRequired();
        return Lists.newArrayList((Iterable)Iterables.transform(this.allFeatures(ApplicationFeatureType.PACKAGE), ApplicationFeature.Functions.GET_FQN));
    }

    @Programmatic
    public List<String> packageNamesContainingClasses(ApplicationMemberType memberType) {
        this.initializeIfRequired();
        Collection<ApplicationFeature> packages = this.allFeatures(ApplicationFeatureType.PACKAGE);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(packages, ApplicationFeature.Predicates.packageContainingClasses(memberType, this)), ApplicationFeature.Functions.GET_FQN));
    }

    @Programmatic
    public List<String> classNamesContainedIn(String packageFqn, ApplicationMemberType memberType) {
        this.initializeIfRequired();
        ApplicationFeatureId packageId = ApplicationFeatureId.newPackage(packageFqn);
        ApplicationFeature pkg = this.findPackage(packageId);
        if (pkg == null) {
            return Collections.emptyList();
        }
        SortedSet<ApplicationFeatureId> contents = pkg.getContents();
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(contents, ApplicationFeatureId.Predicates.isClassContaining(memberType, this)), ApplicationFeatureId.Functions.GET_CLASS_NAME));
    }

    @Programmatic
    public List<String> classNamesRecursivelyContainedIn(String packageFqn) {
        this.initializeIfRequired();
        ApplicationFeatureId packageId = ApplicationFeatureId.newPackage(packageFqn);
        ApplicationFeature pkg = this.findPackage(packageId);
        if (pkg == null) {
            return Collections.emptyList();
        }
        Set<ApplicationFeatureId> classIds = this.classFeatures.keySet();
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(classIds, ApplicationFeatureId.Predicates.isClassRecursivelyWithin(packageId)), ApplicationFeatureId.Functions.GET_CLASS_NAME));
    }

    @Programmatic
    public List<String> memberNamesOf(String packageFqn, String className, ApplicationMemberType memberType) {
        this.initializeIfRequired();
        ApplicationFeatureId classId = ApplicationFeatureId.newClass(packageFqn + "." + className);
        ApplicationFeature cls = this.findClass(classId);
        if (cls == null) {
            return Collections.emptyList();
        }
        SortedSet<ApplicationFeatureId> featureIds = cls.membersOf(memberType);
        return Lists.newArrayList((Iterable)Iterables.transform(featureIds, ApplicationFeatureId.Functions.GET_MEMBER_NAME));
    }

    static enum InitializationState {
        NOT_INITIALIZED,
        INITIALIZED;

    }
}

