/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.deployment.DeploymentCategoryProvider;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.InjectorMethodEvaluator;
import org.apache.isis.core.metamodel.specloader.InjectorMethodEvaluatorDefault;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInjector
implements ApplicationScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInjector.class);
    public static final String KEY_SET_PREFIX = "isis.services.injector.setPrefix";
    public static final String KEY_INJECT_PREFIX = "isis.services.injector.injectPrefix";
    private final List<Object> services = Lists.newArrayList();
    private final Map<Class<?>, List<Object>> servicesAssignableToType = Maps.newHashMap();
    private final Map<Class<?>, Object> serviceByConcreteType = Maps.newHashMap();
    private final InjectorMethodEvaluator injectorMethodEvaluator;
    private final boolean autowireSetters;
    private final boolean autowireInject;
    private AuthenticationManager authenticationManager;
    private AuthorizationManager authorizationManager;
    private SpecificationLoader specificationLoader;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private PersistenceSessionServiceInternal persistenceSessionServiceInternal;
    private ConfigurationServiceInternal configurationServiceInternal;
    private DeploymentCategoryProvider deploymentCategoryProvider;

    public ServicesInjector(List<Object> services, IsisConfiguration configuration) {
        this(services, null, configuration);
    }

    public ServicesInjector(List<Object> services, IsisConfigurationDefault configuration, InjectorMethodEvaluator injectorMethodEvaluator) {
        this(services, injectorMethodEvaluator, ServicesInjector.defaultAutowiring(configuration));
    }

    private static IsisConfiguration defaultAutowiring(IsisConfigurationDefault configuration) {
        configuration.put(KEY_SET_PREFIX, "true");
        configuration.put(KEY_INJECT_PREFIX, "false");
        return configuration;
    }

    private ServicesInjector(List<Object> services, InjectorMethodEvaluator injectorMethodEvaluator, IsisConfiguration configuration) {
        this.services.addAll(services);
        this.injectorMethodEvaluator = injectorMethodEvaluator != null ? injectorMethodEvaluator : new InjectorMethodEvaluatorDefault();
        this.autowireSetters = configuration.getBoolean(KEY_SET_PREFIX, true);
        this.autowireInject = configuration.getBoolean(KEY_INJECT_PREFIX, false);
    }

    public <T> void replaceService(T existingService, T replacementService) {
        if (!this.services.remove(existingService)) {
            throw new IllegalArgumentException("Service to be replaced was not found (" + existingService + ")");
        }
        this.services.add(replacementService);
        this.servicesAssignableToType.clear();
        this.serviceByConcreteType.clear();
        this.autowire();
    }

    public boolean isRegisteredService(Class<?> cls) {
        if (this.serviceByConcreteType.isEmpty()) {
            for (Object service : this.services) {
                Class<?> concreteType = service.getClass();
                this.serviceByConcreteType.put(concreteType, service);
            }
        }
        return this.serviceByConcreteType.containsKey(cls);
    }

    public <T> void addFallbackIfRequired(Class<T> serviceClass, T serviceInstance) {
        if (!ServicesInjector.contains(this.services, serviceClass)) {
            this.services.add(0, serviceInstance);
        }
    }

    public void validateServices() {
        ServicesInjector.validate(this.getRegisteredServices());
    }

    private static void validate(List<Object> serviceList) {
        ArrayListMultimap servicesById = ArrayListMultimap.create();
        for (Object object : serviceList) {
            String id = ServiceUtil.id(object);
            servicesById.put((Object)id, object);
        }
        for (Map.Entry entry : servicesById.asMap().entrySet()) {
            String serviceId = (String)entry.getKey();
            Collection services = (Collection)entry.getValue();
            if (services.size() <= 1) continue;
            throw new IllegalStateException(String.format("Service ids must be unique; serviceId '%s' is declared by domain services %s", serviceId, ServicesInjector.classNamesFor(services)));
        }
    }

    private static String classNamesFor(Collection<Object> services) {
        StringBuilder buf = new StringBuilder();
        for (Object service : services) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(service.getClass().getName());
        }
        return buf.toString();
    }

    static boolean contains(List<Object> services, Class<?> serviceClass) {
        for (Object service : services) {
            if (!serviceClass.isAssignableFrom(service.getClass())) continue;
            return true;
        }
        return false;
    }

    public List<Object> getRegisteredServices() {
        return Collections.unmodifiableList(this.services);
    }

    public void injectServicesInto(Object object) {
        this.injectServices(object, this.services);
    }

    public void injectServicesInto(List<Object> objects) {
        for (Object object : objects) {
            this.injectInto(object);
            this.injectServicesInto(object);
        }
    }

    public void injectInto(Object candidate) {
        if (ServicesInjectorAware.class.isAssignableFrom(candidate.getClass())) {
            ServicesInjectorAware cast = (ServicesInjectorAware)ServicesInjectorAware.class.cast(candidate);
            cast.setServicesInjector(this);
        }
    }

    private void injectServices(Object object, List<Object> services) {
        Class<?> cls = object.getClass();
        this.autowireViaFields(object, services, cls);
        if (this.autowireSetters) {
            this.autowireViaPrefixedMethods(object, services, cls, "set");
        }
        if (this.autowireInject) {
            this.autowireViaPrefixedMethods(object, services, cls, "inject");
        }
    }

    private void autowireViaFields(Object object, List<Object> services, Class<?> cls) {
        List<Field> fields = Arrays.asList(cls.getDeclaredFields());
        Iterable injectFields = Iterables.filter(fields, (Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                Inject annotation = input.getAnnotation(Inject.class);
                return annotation != null;
            }
        });
        for (Field field : injectFields) {
            this.autowire(object, field, services);
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            this.autowireViaFields(object, services, superclass);
        }
    }

    private void autowire(Object object, Field field, List<Object> services) {
        Type genericType;
        Class<?> type = field.getType();
        if (type == null) {
            return;
        }
        if ((Collection.class.isAssignableFrom(type) || List.class.isAssignableFrom(type)) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType listParameterizedType = (ParameterizedType)genericType;
            final Class listType = (Class)listParameterizedType.getActualTypeArguments()[0];
            List listOfServices = Collections.unmodifiableList(Lists.newArrayList((Iterable)Iterables.filter(services, (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return input != null && listType.isAssignableFrom(input.getClass());
                }
            })));
            ServicesInjector.invokeInjectorField(field, object, listOfServices);
        }
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            if (!type.isAssignableFrom(serviceClass)) continue;
            ServicesInjector.invokeInjectorField(field, object, service);
            return;
        }
    }

    private void autowireViaPrefixedMethods(Object object, List<Object> services, Class<?> cls, final String prefix) {
        List<Method> methods = Arrays.asList(cls.getMethods());
        Iterable prefixedMethods = Iterables.filter(methods, (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                String methodName = method.getName();
                return methodName.startsWith(prefix);
            }
        });
        for (Method prefixedMethod : prefixedMethods) {
            this.autowire(object, prefixedMethod, services);
        }
    }

    private void autowire(Object object, Method prefixedMethod, List<Object> services) {
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            boolean isInjectorMethod = this.injectorMethodEvaluator.isInjectorMethodFor(prefixedMethod, serviceClass);
            if (!isInjectorMethod) continue;
            prefixedMethod.setAccessible(true);
            ServicesInjector.invokeInjectorMethod(prefixedMethod, object, service);
            return;
        }
    }

    private static void invokeMethod(Method method, Object target, Object[] parameters) {
        try {
            method.invoke(target, parameters);
        }
        catch (IllegalAccessException | SecurityException e) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (IllegalArgumentException e1) {
            throw new MetaModelException(e1);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new MetaModelException(targetException);
        }
    }

    private static void invokeInjectorField(Field field, Object target, Object parameter) {
        try {
            field.setAccessible(true);
            field.set(target, parameter);
        }
        catch (IllegalArgumentException e) {
            throw new MetaModelException(e);
        }
        catch (IllegalAccessException e) {
            throw new MetaModelException(String.format("Cannot access the %s field in %s", field.getName(), target.getClass().getName()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected {} into {}", parameter, (Object)new ToString(target));
        }
    }

    private static void invokeInjectorMethod(Method method, Object target, Object parameter) {
        Object[] parameters = new Object[]{parameter};
        ServicesInjector.invokeMethod(method, target, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected {} into {}", parameter, (Object)new ToString(target));
        }
    }

    @Programmatic
    public void autowire() {
        this.injectServicesInto(this.services);
    }

    @Programmatic
    public <T> T lookupService(Class<T> serviceClass) {
        List<T> services = this.lookupServices(serviceClass);
        return !services.isEmpty() ? (T)services.get(0) : null;
    }

    @Programmatic
    public <T> boolean isService(Class<T> serviceClass) {
        this.locateAndCache(serviceClass);
        return this.servicesAssignableToType.get(serviceClass) != null;
    }

    @Programmatic
    public <T> T lookupServiceElseFail(Class<T> serviceClass) {
        T service = this.lookupService(serviceClass);
        if (service == null) {
            throw new IllegalStateException(String.format("Could not locate service of type '%s'", serviceClass));
        }
        return service;
    }

    @Programmatic
    public <T> List<T> lookupServices(Class<T> serviceClass) {
        this.locateAndCache(serviceClass);
        ArrayList servicesAssignableToType = this.servicesAssignableToType.get(serviceClass);
        if (servicesAssignableToType == null) {
            LOG.info(String.format("ServicesInjector#lookupServices: called with %s; stack trace:\n%s", serviceClass, Throwables.getStackTraceAsString((Throwable)new Exception())));
            servicesAssignableToType = Lists.newArrayList();
        }
        return Collections.unmodifiableList(servicesAssignableToType);
    }

    private void locateAndCache(Class<?> serviceClass) {
        if (this.servicesAssignableToType.containsKey(serviceClass)) {
            return;
        }
        ArrayList matchingServices = Lists.newArrayList();
        ServicesInjector.addAssignableTo(serviceClass, this.services, matchingServices);
        this.servicesAssignableToType.put(serviceClass, matchingServices);
    }

    private static void addAssignableTo(Class<?> type, List<Object> candidates, List<Object> filteredServicesAndContainer) {
        Iterable filteredServices = Iterables.filter(candidates, ServicesInjector.ofType(type));
        filteredServicesAndContainer.addAll(Lists.newArrayList((Iterable)filteredServices));
    }

    private static final Predicate<Object> ofType(final Class<?> cls) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return cls.isAssignableFrom(input.getClass());
            }
        };
    }

    @Programmatic
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager != null ? this.authenticationManager : (this.authenticationManager = this.lookupServiceElseFail(AuthenticationManager.class));
    }

    @Programmatic
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager != null ? this.authorizationManager : (this.authorizationManager = this.lookupServiceElseFail(AuthorizationManager.class));
    }

    @Programmatic
    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader != null ? this.specificationLoader : (this.specificationLoader = this.lookupServiceElseFail(SpecificationLoader.class));
    }

    @Programmatic
    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider != null ? this.authenticationSessionProvider : (this.authenticationSessionProvider = this.lookupServiceElseFail(AuthenticationSessionProvider.class));
    }

    @Programmatic
    public PersistenceSessionServiceInternal getPersistenceSessionServiceInternal() {
        return this.persistenceSessionServiceInternal != null ? this.persistenceSessionServiceInternal : (this.persistenceSessionServiceInternal = this.lookupServiceElseFail(PersistenceSessionServiceInternal.class));
    }

    @Programmatic
    public ConfigurationServiceInternal getConfigurationServiceInternal() {
        return this.configurationServiceInternal != null ? this.configurationServiceInternal : (this.configurationServiceInternal = this.lookupServiceElseFail(ConfigurationServiceInternal.class));
    }

    @Programmatic
    public DeploymentCategoryProvider getDeploymentCategoryProvider() {
        return this.deploymentCategoryProvider != null ? this.deploymentCategoryProvider : (this.deploymentCategoryProvider = this.lookupServiceElseFail(DeploymentCategoryProvider.class));
    }
}

