/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.core.commons.exceptions.IsisException;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    public static String id(Class<?> serviceClass) {
        String serviceType = ServiceUtil.serviceTypeOf(serviceClass);
        if (serviceType != null) {
            return serviceType;
        }
        try {
            Object object = serviceClass.newInstance();
            return ServiceUtil.getIdOf(object);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            return null;
        }
    }

    public static String id(Object object) {
        Class<?> serviceClass = object.getClass();
        String serviceType = ServiceUtil.serviceTypeOf(serviceClass);
        if (serviceType != null) {
            return serviceType;
        }
        try {
            return ServiceUtil.getIdOf(object);
        }
        catch (NoSuchMethodException e) {
            return ServiceUtil.fqcnOf(serviceClass);
        }
    }

    private static String serviceTypeOf(Class<?> serviceClass) {
        String serviceType;
        DomainService domainService = serviceClass.getAnnotation(DomainService.class);
        if (domainService != null && !Strings.isNullOrEmpty((String)(serviceType = domainService.objectType()))) {
            return serviceType;
        }
        return null;
    }

    private static String getIdOf(Object object) throws NoSuchMethodException {
        try {
            Class<?> objectClass = object.getClass();
            Method m = objectClass.getMethod("getId", new Class[0]);
            return (String)m.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new IsisException(e);
        }
    }

    private static String fqcnOf(Class<?> serviceClass) {
        return serviceClass.getName();
    }
}

