/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.postprocessors.param;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.applib.services.eventbus.CollectionDomainEvent;
import org.apache.isis.applib.services.eventbus.PropertyDomainEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.deployment.DeploymentCategoryProvider;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.CollectionAnnotationFacetFactory;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.disabled.fromimmutable.DisabledFacetOnCollectionDerivedFromImmutable;
import org.apache.isis.core.metamodel.facets.members.describedas.annotprop.DescribedAsFacetOnMemberDerivedFromType;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultedFacet;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.ActionDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.CollectionDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.PropertyDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.recreatable.DisabledFacetOnCollectionDerivedFromRecreatableObject;
import org.apache.isis.core.metamodel.facets.object.recreatable.DisabledFacetOnPropertyDerivedFromRecreatableObject;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.choices.ChoicesFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.choices.enums.ActionParameterChoicesFacetDerivedFromChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.fromtype.ActionParameterDefaultFacetDerivedFromTypeFacets;
import org.apache.isis.core.metamodel.facets.param.describedas.annotderived.DescribedAsFacetOnParameterDerivedFromType;
import org.apache.isis.core.metamodel.facets.param.typicallen.fromtype.TypicalLengthFacetOnParameterDerivedFromType;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.enums.PropertyChoicesFacetDerivedFromChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.fromtype.PropertyDefaultFacetDerivedFromDefaultedFacet;
import org.apache.isis.core.metamodel.facets.properties.disabled.fromimmutable.DisabledFacetOnPropertyDerivedFromImmutable;
import org.apache.isis.core.metamodel.facets.properties.property.PropertyAnnotationFacetFactory;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacet;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.typicallen.fromtype.TypicalLengthFacetOnPropertyDerivedFromType;
import org.apache.isis.core.metamodel.postprocessors.param.ActionParameterChoicesFacetFromParentedCollection;
import org.apache.isis.core.metamodel.postprocessors.param.ActionParameterDefaultsFacetFromAssociatedCollection;
import org.apache.isis.core.metamodel.progmodel.ObjectSpecificationPostProcessor;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationMixedIn;

public class DeriveFacetsPostProcessor
implements ObjectSpecificationPostProcessor,
ServicesInjectorAware {
    private DeploymentCategoryProvider deploymentCategoryProvider;
    private SpecificationLoader specificationLoader;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private PersistenceSessionServiceInternal adapterManager;
    private ServicesInjector servicesInjector;

    @Override
    public void postProcess(ObjectSpecification objectSpecification) {
        List<ActionType> actionTypes = this.inferActionTypes();
        List<ObjectAction> objectActions = objectSpecification.getObjectActions(actionTypes, Contributed.INCLUDED, (Filter<ObjectAction>)Filters.any());
        List<OneToManyAssociation> collections = objectSpecification.getCollections(Contributed.INCLUDED);
        List<OneToOneAssociation> properties = objectSpecification.getProperties(Contributed.INCLUDED);
        for (ObjectAction objectAction : objectActions) {
            List<ObjectActionParameter> parameters = objectAction.getParameters();
            for (ObjectActionParameter parameter : parameters) {
                this.deriveParameterDefaultFacetFromType(parameter);
                this.deriveParameterChoicesFromExistingChoices(parameter);
                this.deriveParameterDescribedAsFromType(parameter);
                this.deriveParameterTypicalLengthFromType(parameter);
            }
            this.deriveActionDescribedAsFromType(objectAction);
            this.tweakActionDomainEventForMixin(objectSpecification, objectAction);
        }
        for (OneToOneAssociation property : properties) {
            this.derivePropertyChoicesFromExistingChoices(property);
            this.derivePropertyDefaultsFromType(property);
            this.derivePropertyTypicalLengthFromType(property);
            this.derivePropertyOrCollectionDescribedAsFromType(property);
            this.derivePropertyDisabledFromViewModel(property);
            this.derivePropertyOrCollectionImmutableFromSpec(property);
            this.derivePropertyDisabledFromImmutable(property);
            this.tweakPropertyMixinDomainEvent(objectSpecification, property);
        }
        for (OneToManyAssociation collection : collections) {
            this.derivePropertyOrCollectionDescribedAsFromType(collection);
            this.deriveCollectionDisabledFromViewModel(collection);
            this.derivePropertyOrCollectionImmutableFromSpec(collection);
            this.deriveCollectionDisabledFromImmutable(collection);
            ObjectSpecification specification = collection.getSpecification();
            ObjectActionParameter.Predicates.CollectionParameter whetherCollectionParamOfType = new ObjectActionParameter.Predicates.CollectionParameter(specification);
            ObjectActionParameter.Predicates.ScalarParameter whetherScalarParamOfType = new ObjectActionParameter.Predicates.ScalarParameter(specification);
            ImmutableList actionsAssociatedWithCollection = FluentIterable.from(objectActions).filter(ObjectAction.Predicates.associatedWith(collection)).toList();
            for (ObjectAction action : actionsAssociatedWithCollection) {
                List<ObjectActionParameter> parameters = action.getParameters();
                ImmutableList compatibleCollectionParams = FluentIterable.from(parameters).filter((Predicate)whetherCollectionParamOfType).toList();
                ImmutableList compatibleScalarParams = FluentIterable.from(parameters).filter((Predicate)whetherScalarParamOfType).toList();
                for (ObjectActionParameter collectionParam : compatibleCollectionParams) {
                    this.addCollectionParamDefaultsFacetIfNoneAlready(collectionParam);
                }
                for (ObjectActionParameter collectionParam : compatibleCollectionParams) {
                    this.addCollectionParamChoicesFacetIfNoneAlready(collection, collectionParam);
                }
                for (ObjectActionParameter scalarParam : compatibleScalarParams) {
                    this.addCollectionParamChoicesFacetIfNoneAlready(collection, scalarParam);
                }
            }
            this.deriveCollectionDomainEventForMixins(objectSpecification, collection);
        }
    }

    private void tweakActionDomainEventForMixin(ObjectSpecification objectSpecification, ObjectAction objectAction) {
        ActionDomainEventFacetAbstract facetAbstract;
        ObjectActionMixedIn actionMixedIn;
        ActionDomainEventFacet actionFacet;
        ActionDomainEventDefaultFacetForDomainObjectAnnotation actionDomainEventDefaultFacet;
        if (objectAction instanceof ObjectActionMixedIn && (actionDomainEventDefaultFacet = objectSpecification.getFacet(ActionDomainEventDefaultFacetForDomainObjectAnnotation.class)) != null && (actionFacet = (actionMixedIn = (ObjectActionMixedIn)objectAction).getFacet(ActionDomainEventFacet.class)) instanceof ActionDomainEventFacetAbstract && (facetAbstract = (ActionDomainEventFacetAbstract)actionFacet).getEventType() == ActionDomainEvent.Default.class) {
            ActionDomainEventFacetAbstract existing = (ActionDomainEventFacetAbstract)actionFacet;
            existing.setEventType(actionDomainEventDefaultFacet.getEventType());
        }
    }

    private void deriveCollectionDomainEventForMixins(ObjectSpecification objectSpecification, OneToManyAssociation collection) {
        if (collection instanceof OneToManyAssociationMixedIn) {
            Method method;
            OneToManyAssociationMixedIn collectionMixin = (OneToManyAssociationMixedIn)collection;
            FacetedMethod facetedMethod = collectionMixin.getFacetedMethod();
            Method method2 = method = facetedMethod != null ? facetedMethod.getMethod() : null;
            if (method != null) {
                CollectionDomainEventFacetAbstract facetAbstract;
                CollectionDomainEventFacet collectionFacet;
                CollectionDomainEventDefaultFacetForDomainObjectAnnotation collectionDomainEventDefaultFacet;
                Collection collectionAnnot = Annotations.getAnnotation(method, Collection.class);
                if (collectionAnnot != null) {
                    Class<? extends CollectionDomainEvent<?, ?>> collectionDomainEventType = CollectionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(objectSpecification, collectionAnnot.domainEvent());
                    CollectionDomainEventFacetForCollectionAnnotation collectionDomainEventFacet = new CollectionDomainEventFacetForCollectionAnnotation(collectionDomainEventType, this.servicesInjector, this.specificationLoader, collection);
                    FacetUtil.addFacet(collectionDomainEventFacet);
                }
                if ((collectionDomainEventDefaultFacet = objectSpecification.getFacet(CollectionDomainEventDefaultFacetForDomainObjectAnnotation.class)) != null && (collectionFacet = collection.getFacet(CollectionDomainEventFacet.class)) instanceof CollectionDomainEventFacetAbstract && (facetAbstract = (CollectionDomainEventFacetAbstract)collectionFacet).getEventType() == CollectionDomainEvent.Default.class) {
                    CollectionDomainEventFacetAbstract existing = (CollectionDomainEventFacetAbstract)collectionFacet;
                    existing.setEventType(collectionDomainEventDefaultFacet.getEventType());
                }
            }
        }
    }

    private void tweakPropertyMixinDomainEvent(ObjectSpecification objectSpecification, OneToOneAssociation property) {
        if (property instanceof OneToOneAssociationMixedIn) {
            PropertyDomainEventFacetAbstract facetAbstract;
            PropertyDomainEventFacet propertyFacet;
            PropertyDomainEventDefaultFacetForDomainObjectAnnotation propertyDomainEventDefaultFacet;
            Property propertyAnnot;
            Method method;
            OneToOneAssociationMixedIn propertyMixin = (OneToOneAssociationMixedIn)property;
            FacetedMethod facetedMethod = propertyMixin.getFacetedMethod();
            Method method2 = method = facetedMethod != null ? facetedMethod.getMethod() : null;
            if (method != null && (propertyAnnot = Annotations.getAnnotation(method, Property.class)) != null) {
                Class<? extends PropertyDomainEvent<?, ?>> propertyDomainEventType = PropertyAnnotationFacetFactory.defaultFromDomainObjectIfRequired(objectSpecification, propertyAnnot.domainEvent());
                PropertyOrCollectionAccessorFacet getterFacetIfAny = null;
                PropertyDomainEventFacetForPropertyAnnotation propertyDomainEventFacet = new PropertyDomainEventFacetForPropertyAnnotation(propertyDomainEventType, getterFacetIfAny, this.servicesInjector, this.specificationLoader, property);
                FacetUtil.addFacet(propertyDomainEventFacet);
            }
            if ((propertyDomainEventDefaultFacet = objectSpecification.getFacet(PropertyDomainEventDefaultFacetForDomainObjectAnnotation.class)) != null && (propertyFacet = property.getFacet(PropertyDomainEventFacet.class)) instanceof PropertyDomainEventFacetAbstract && (facetAbstract = (PropertyDomainEventFacetAbstract)propertyFacet).getEventType() == PropertyDomainEvent.Default.class) {
                PropertyDomainEventFacetAbstract existing = (PropertyDomainEventFacetAbstract)propertyFacet;
                existing.setEventType(propertyDomainEventDefaultFacet.getEventType());
            }
        }
    }

    static DisabledFacetAbstract.Semantics inferSemanticsFrom(ViewModelFacet facet) {
        return facet.isImplicitlyImmutable() ? DisabledFacetAbstract.Semantics.DISABLED : DisabledFacetAbstract.Semantics.ENABLED;
    }

    private FacetedMethod facetedMethodFor(ObjectMember objectMember) {
        ObjectMemberAbstract objectActionImpl = (ObjectMemberAbstract)objectMember;
        return objectActionImpl.getFacetedMethod();
    }

    private TypedHolder peerFor(ObjectActionParameter param) {
        ObjectActionParameterAbstract objectActionImpl = (ObjectActionParameterAbstract)param;
        return objectActionImpl.getPeer();
    }

    private void deriveActionDescribedAsFromType(ObjectAction objectAction) {
        if (objectAction.containsDoOpFacet(DescribedAsFacet.class)) {
            return;
        }
        ObjectSpecification returnSpec = objectAction.getReturnType();
        DescribedAsFacet specFacet = returnSpec.getFacet(DescribedAsFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new DescribedAsFacetOnMemberDerivedFromType(specFacet, (FacetHolder)this.facetedMethodFor(objectAction)));
        }
    }

    private void deriveParameterDefaultFacetFromType(ObjectActionParameter parameter) {
        if (parameter.containsDoOpFacet(ActionDefaultsFacet.class)) {
            return;
        }
        ObjectAction objectAction = parameter.getAction();
        List<ObjectSpecification> parameterSpecs = objectAction.getParameterTypes();
        DefaultedFacet[] parameterTypeDefaultedFacets = new DefaultedFacet[parameterSpecs.size()];
        boolean hasAtLeastOneDefault = false;
        for (int i = 0; i < parameterSpecs.size(); ++i) {
            ObjectSpecification parameterSpec = parameterSpecs.get(i);
            parameterTypeDefaultedFacets[i] = parameterSpec.getFacet(DefaultedFacet.class);
            hasAtLeastOneDefault |= parameterTypeDefaultedFacets[i] != null;
        }
        if (hasAtLeastOneDefault) {
            FacetUtil.addFacet(new ActionParameterDefaultFacetDerivedFromTypeFacets(parameterTypeDefaultedFacets, this.peerFor(parameter)));
        }
    }

    private void deriveParameterChoicesFromExistingChoices(ObjectActionParameter parameter) {
        if (parameter.containsDoOpFacet(ActionParameterChoicesFacet.class)) {
            return;
        }
        ObjectSpecification paramSpec = parameter.getSpecification();
        ChoicesFacet specFacet = paramSpec.getFacet(ChoicesFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new ActionParameterChoicesFacetDerivedFromChoicesFacet(this.peerFor(parameter), this.getDeploymentCategory(), this.specificationLoader, this.authenticationSessionProvider, this.adapterManager));
        }
    }

    private void deriveParameterDescribedAsFromType(ObjectActionParameter parameter) {
        if (parameter.containsDoOpFacet(DescribedAsFacet.class)) {
            return;
        }
        ObjectSpecification paramSpec = parameter.getSpecification();
        DescribedAsFacet specFacet = paramSpec.getFacet(DescribedAsFacet.class);
        if (specFacet != null) {
            FacetUtil.addFacet(new DescribedAsFacetOnParameterDerivedFromType(specFacet, (FacetHolder)this.peerFor(parameter)));
        }
    }

    private void deriveParameterTypicalLengthFromType(ObjectActionParameter parameter) {
        if (parameter.containsDoOpFacet(TypicalLengthFacet.class)) {
            return;
        }
        ObjectSpecification paramSpec = parameter.getSpecification();
        TypicalLengthFacet specFacet = paramSpec.getFacet(TypicalLengthFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new TypicalLengthFacetOnParameterDerivedFromType(specFacet, this.peerFor(parameter)));
        }
    }

    private void derivePropertyChoicesFromExistingChoices(OneToOneAssociation property) {
        if (property.containsDoOpFacet(PropertyChoicesFacet.class)) {
            return;
        }
        ObjectSpecification propertySpec = property.getSpecification();
        ChoicesFacet specFacet = propertySpec.getFacet(ChoicesFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new PropertyChoicesFacetDerivedFromChoicesFacet(this.facetedMethodFor(property), this.specificationLoader));
        }
    }

    private void derivePropertyDefaultsFromType(OneToOneAssociation property) {
        if (property.containsDoOpFacet(PropertyDefaultFacet.class)) {
            return;
        }
        ObjectSpecification propertySpec = property.getSpecification();
        DefaultedFacet specFacet = propertySpec.getFacet(DefaultedFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new PropertyDefaultFacetDerivedFromDefaultedFacet(specFacet, (FacetHolder)this.facetedMethodFor(property), this.adapterManager));
        }
    }

    private void derivePropertyTypicalLengthFromType(OneToOneAssociation property) {
        if (property.containsDoOpFacet(TypicalLengthFacet.class)) {
            return;
        }
        ObjectSpecification propertySpec = property.getSpecification();
        TypicalLengthFacet specFacet = propertySpec.getFacet(TypicalLengthFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new TypicalLengthFacetOnPropertyDerivedFromType(specFacet, this.facetedMethodFor(property)));
        }
    }

    private void derivePropertyOrCollectionDescribedAsFromType(ObjectAssociation objectAssociation) {
        if (objectAssociation.containsDoOpFacet(DescribedAsFacet.class)) {
            return;
        }
        ObjectSpecification returnSpec = objectAssociation.getSpecification();
        DescribedAsFacet specFacet = returnSpec.getFacet(DescribedAsFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new DescribedAsFacetOnMemberDerivedFromType(specFacet, (FacetHolder)this.facetedMethodFor(objectAssociation)));
        }
    }

    private void derivePropertyDisabledFromViewModel(OneToOneAssociation property) {
        if (property.containsDoOpFacet(DisabledFacet.class)) {
            return;
        }
        ObjectSpecification propertySpec = property.getOnType();
        ViewModelFacet specFacet = propertySpec.getFacet(ViewModelFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            DisabledFacetAbstract.Semantics semantics = DeriveFacetsPostProcessor.inferSemanticsFrom(specFacet);
            FacetUtil.addFacet(new DisabledFacetOnPropertyDerivedFromRecreatableObject(this.facetedMethodFor(property), semantics));
        }
    }

    private void derivePropertyDisabledFromImmutable(OneToOneAssociation property) {
        if (property.containsDoOpFacet(DisabledFacet.class)) {
            return;
        }
        ObjectSpecification onType = property.getOnType();
        ImmutableFacet specFacet = onType.getFacet(ImmutableFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new DisabledFacetOnPropertyDerivedFromImmutable(specFacet, this.facetedMethodFor(property)));
        }
    }

    private void derivePropertyOrCollectionImmutableFromSpec(ObjectAssociation objectAssociation) {
        if (objectAssociation.containsDoOpFacet(DisabledFacet.class)) {
            return;
        }
        ObjectSpecification owningSpec = objectAssociation.getOnType();
        ImmutableFacet specFacet = owningSpec.getFacet(ImmutableFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            specFacet.copyOnto(this.facetedMethodFor(objectAssociation));
        }
    }

    private void deriveCollectionDisabledFromViewModel(OneToManyAssociation collection) {
        if (collection.containsDoOpFacet(DisabledFacet.class)) {
            return;
        }
        ObjectSpecification collectionSpec = collection.getOnType();
        ViewModelFacet specFacet = collectionSpec.getFacet(ViewModelFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            DisabledFacetAbstract.Semantics semantics = DeriveFacetsPostProcessor.inferSemanticsFrom(specFacet);
            FacetUtil.addFacet(new DisabledFacetOnCollectionDerivedFromRecreatableObject(this.facetedMethodFor(collection), semantics));
        }
    }

    private void deriveCollectionDisabledFromImmutable(OneToManyAssociation collection) {
        if (collection.containsDoOpFacet(DisabledFacet.class)) {
            return;
        }
        ObjectSpecification onType = collection.getOnType();
        ImmutableFacet specFacet = onType.getFacet(ImmutableFacet.class);
        if (DeriveFacetsPostProcessor.existsAndIsDoOp(specFacet)) {
            FacetUtil.addFacet(new DisabledFacetOnCollectionDerivedFromImmutable(specFacet, this.facetedMethodFor(collection)));
        }
    }

    private void addCollectionParamDefaultsFacetIfNoneAlready(ObjectActionParameter collectionParam) {
        if (collectionParam.containsDoOpFacet(ActionParameterDefaultsFacet.class)) {
            return;
        }
        FacetUtil.addFacet(new ActionParameterDefaultsFacetFromAssociatedCollection(collectionParam));
    }

    private void addCollectionParamChoicesFacetIfNoneAlready(OneToManyAssociation otma, ObjectActionParameter scalarOrCollectionParam) {
        if (scalarOrCollectionParam.containsDoOpFacet(ActionParameterChoicesFacet.class) || scalarOrCollectionParam.containsDoOpFacet(ActionParameterAutoCompleteFacet.class)) {
            return;
        }
        FacetUtil.addFacet(new ActionParameterChoicesFacetFromParentedCollection(scalarOrCollectionParam, otma, this.getDeploymentCategory(), this.specificationLoader, this.authenticationSessionProvider, this.adapterManager));
    }

    private static boolean existsAndIsDoOp(Facet facet) {
        return facet != null && !facet.isNoop();
    }

    private List<ActionType> inferActionTypes() {
        ArrayList actionTypes = Lists.newArrayList();
        actionTypes.add(ActionType.USER);
        DeploymentCategory deploymentCategory = this.getDeploymentCategory();
        if (!deploymentCategory.isProduction()) {
            actionTypes.add(ActionType.PROTOTYPE);
        }
        return actionTypes;
    }

    private DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategoryProvider.getDeploymentCategory();
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
        this.deploymentCategoryProvider = servicesInjector.getDeploymentCategoryProvider();
        this.specificationLoader = servicesInjector.getSpecificationLoader();
        this.authenticationSessionProvider = servicesInjector.getAuthenticationSessionProvider();
        this.adapterManager = servicesInjector.getPersistenceSessionServiceInternal();
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }
}

