/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.postprocessors.param;

import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacetAbstract;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class ActionParameterChoicesFacetFromParentedCollection
extends ActionParameterChoicesFacetAbstract {
    private final OneToManyAssociation otma;

    public ActionParameterChoicesFacetFromParentedCollection(FacetHolder holder, OneToManyAssociation otma, DeploymentCategory deploymentCategory, SpecificationLoader specificationLoader, AuthenticationSessionProvider authenticationSessionProvider, AdapterManager adapterManager) {
        super(holder, deploymentCategory, specificationLoader, authenticationSessionProvider, adapterManager);
        this.otma = otma;
    }

    @Override
    public Object[] getChoices(ObjectAdapter target, List<ObjectAdapter> arguments, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter parentAdapter = this.determineParentAdapter(target);
        ObjectAdapter objectAdapter = this.otma.get(parentAdapter, interactionInitiatedBy);
        List<ObjectAdapter> objectAdapters = CollectionFacet.Utils.convertToAdapterList(objectAdapter);
        return ObjectAdapter.Util.unwrap(objectAdapters.toArray(new ObjectAdapter[0]));
    }

    private ObjectAdapter determineParentAdapter(ObjectAdapter target) {
        MixinFacet mixinFacet = target.getSpecification().getFacet(MixinFacet.class);
        ObjectAdapter mixedInTarget = null;
        if (mixinFacet != null) {
            mixedInTarget = mixinFacet.mixedIn(target, MixinFacet.Policy.FAIL_FAST);
        }
        return mixedInTarget != null ? mixedInTarget : target;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("oneToManyAssociation", this.otma);
    }
}

