/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionContextType;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;

public abstract class InteractionContext<T extends InteractionEvent> {
    private final InteractionContextType interactionType;
    private final Identifier identifier;
    private final InteractionInitiatedBy interactionInitiatedBy;
    private final ObjectAdapter target;
    private int contributeeParam = -1;
    private ObjectAdapter contributee = null;
    private ObjectAdapter mixedInAdapter = null;

    public InteractionContext(InteractionContextType interactionType, InteractionInitiatedBy invocationMethod, Identifier identifier, ObjectAdapter target) {
        this.interactionType = interactionType;
        this.interactionInitiatedBy = invocationMethod;
        this.identifier = identifier;
        this.target = target;
    }

    public InteractionContextType getInteractionType() {
        return this.interactionType;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public InteractionInitiatedBy getInitiatedBy() {
        return this.interactionInitiatedBy;
    }

    public boolean isFrameworkInitiated() {
        return this.interactionInitiatedBy == InteractionInitiatedBy.FRAMEWORK;
    }

    public ObjectAdapter getTarget() {
        return this.target;
    }

    public void putContributee(int contributeeParam, ObjectAdapter contributee) {
        this.contributeeParam = contributeeParam;
        this.contributee = contributee;
    }

    public Map<Integer, ObjectAdapter> getContributeeAsMap() {
        return this.contributee != null ? ImmutableMap.of((Object)this.contributeeParam, (Object)this.contributee) : ImmutableMap.of();
    }

    public void setMixedIn(ObjectAdapter mixedInAdapter) {
        this.mixedInAdapter = mixedInAdapter;
    }

    public ObjectAdapter getMixedIn() {
        return this.mixedInAdapter;
    }

    public abstract T createInteractionEvent();
}

