/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.url;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.url.URLValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class URLValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<URL>
implements URLValueFacet {
    public static final int MAX_LENGTH = 2083;
    private static final int TYPICAL_LENGTH = 100;
    private static final URL DEFAULT_VALUE = null;

    public static Class<? extends Facet> type() {
        return URLValueFacet.class;
    }

    public URLValueSemanticsProvider() {
        this(null, null);
    }

    public URLValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(URLValueSemanticsProvider.type(), holder, URL.class, 100, 2083, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected URL doParse(Object context, String entry) {
        if (entry.trim().equals("")) {
            return null;
        }
        try {
            return new URL(entry);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Not parseable as a URL ('" + entry + "')", ex);
        }
    }

    @Override
    public String titleString(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public String titleStringWithMask(Object object, String usingMask) {
        return this.titleString(object);
    }

    @Override
    protected String doEncode(Object object) {
        URL url = (URL)object;
        return url != null ? url.toString() : "NULL";
    }

    @Override
    protected URL doRestore(String data) {
        if ("NULL".equals(data)) {
            return null;
        }
        try {
            return new URL(data);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL urlValue(ObjectAdapter object) {
        return object == null ? null : (URL)object.getObject();
    }

    @Override
    public ObjectAdapter createValue(URL value) {
        return this.getAdapterManager().adapterFor(value);
    }

    @Override
    public String toString() {
        return "URLValueSemanticsProvider";
    }
}

