/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.timestamp;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.isis.applib.value.TimeStamp;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.ValueSemanticsProviderAbstractTemporal;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class TimeStampValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static final Object DEFAULT_VALUE = null;
    private static final int TYPICAL_LENGTH = 25;

    protected static void initFormats(Map<String, DateFormat> formats) {
        formats.put("iso_encoding", TimeStampValueSemanticsProviderAbstract.createDateEncodingFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("short", DateFormat.getDateTimeInstance(3, 1));
    }

    public TimeStampValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, ServicesInjector context) {
        super("timestamp", holder, adaptedClass, 25, ValueSemanticsProviderAndFacetAbstract.Immutability.NOT_IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, context);
        String formatRequired = this.getConfiguration().getString("isis.value.format.timestamp");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    protected T add(T original, int years, int months, int days, int hours, int minutes) {
        return original;
    }

    @Override
    protected Date dateValue(Object value) {
        return new Date(((TimeStamp)value).longValue());
    }

    @Override
    protected String defaultFormat() {
        return "short";
    }

    @Override
    public String toString() {
        return "TimeStampValueSemanticsProvider: " + this.format;
    }

    @Override
    protected DateFormat format() {
        Locale locale = Locale.getDefault();
        TimeZone timeZone = TimeZone.getDefault();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, locale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat;
    }

    @Override
    protected List<DateFormat> formatsToTry() {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        Locale locale = Locale.getDefault();
        TimeZone timeZone = TimeZone.getDefault();
        formats.add(DateFormat.getDateTimeInstance(2, 1, locale));
        formats.add(DateFormat.getDateTimeInstance(3, 1, locale));
        formats.add(TimeStampValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        for (DateFormat format : formats) {
            format.setTimeZone(timeZone);
        }
        return formats;
    }
}

