/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.timesql;

import com.google.common.collect.Maps;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.value.time.TimeValueSemanticsProviderAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class JavaSqlTimeValueSemanticsProvider
extends TimeValueSemanticsProviderAbstract<Time> {
    private static Map<String, DateFormat> formats = Maps.newHashMap();

    public JavaSqlTimeValueSemanticsProvider() {
        this(null, null);
    }

    public JavaSqlTimeValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(holder, Time.class, context);
    }

    @Override
    public Time add(Time original, int years, int months, int days, int hours, int minutes) {
        Time time = original;
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 0);
        cal.set(14, 0);
        cal.add(10, hours);
        cal.add(12, minutes);
        return this.setDate(cal.getTime());
    }

    @Override
    public Date dateValue(Object object) {
        Time time = (Time)object;
        return time == null ? null : new Date(time.getTime());
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return formats;
    }

    @Override
    protected Time now() {
        return new Time(Clock.getTime());
    }

    @Override
    protected Time setDate(Date date) {
        return new Time(date.getTime());
    }

    static {
        JavaSqlTimeValueSemanticsProvider.initFormats(formats);
    }
}

