/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.longs;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.longs.LongValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class LongValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Long>
implements LongValueFacet {
    private static final Long DEFAULT_VALUE = 0L;
    private static final int MAX_LENGTH = 18;
    private static final int TYPICAL_LENGTH = 18;
    private final NumberFormat format = this.determineNumberFormat("value.format.long");

    public static Class<? extends Facet> type() {
        return LongValueFacet.class;
    }

    public LongValueSemanticsProviderAbstract(FacetHolder holder, Class<Long> adaptedClass, ServicesInjector context) {
        super(LongValueSemanticsProviderAbstract.type(), holder, adaptedClass, 18, 18, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected Long doParse(Object context, String entry) {
        try {
            return this.format.parse(entry).longValue();
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a whole number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Long doRestore(String data) {
        return new Long(data);
    }

    @Override
    public Long longValue(ObjectAdapter object) {
        return (Long)(object == null ? null : object.getObject());
    }

    @Override
    public ObjectAdapter createValue(Long value) {
        return value == null ? null : this.getAdapterManager().adapterFor(value);
    }

    @Override
    public String toString() {
        return "LongValueSemanticsProvider: " + this.format;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("format", this.format);
    }
}

