/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.doubles;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.doubles.DoubleFloatingPointValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class DoubleValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Double>
implements DoubleFloatingPointValueFacet {
    private static final Double DEFAULT_VALUE = new Double(0.0);
    private static final int MAX_LENGTH = 25;
    private static final int TYPICAL_LENGTH = 10;
    private final NumberFormat format = this.determineNumberFormat("value.format.double");

    private static Class<? extends Facet> type() {
        return DoubleFloatingPointValueFacet.class;
    }

    public DoubleValueSemanticsProviderAbstract(FacetHolder holder, Class<Double> adaptedClass, ServicesInjector context) {
        super(DoubleValueSemanticsProviderAbstract.type(), holder, adaptedClass, 10, 25, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected Double doParse(Object context, String entry) {
        try {
            return new Double(this.format.parse(entry).doubleValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not floating point number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Double doRestore(String data) {
        return new Double(data);
    }

    @Override
    public Double doubleValue(ObjectAdapter object) {
        return (Double)(object == null ? null : object.getObject());
    }

    @Override
    public ObjectAdapter createValue(Double value) {
        return this.getAdapterManager().adapterFor(value);
    }

    @Override
    public String toString() {
        return "DoubleValueSemanticsProvider: " + this.format;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("format", this.format);
    }
}

