/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.update.init;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.properties.update.init.PropertyInitializationFacetAbstract;

public class PropertyInitializationFacetViaSetterMethod
extends PropertyInitializationFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public PropertyInitializationFacetViaSetterMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.MODIFY_PROPERTY;
    }

    @Override
    public void initProperty(ObjectAdapter owningAdapter, ObjectAdapter initialAdapter) {
        ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter, initialAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

