/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.propertylayout;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.CssClassFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.CssClassFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.DescribedAsFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.DescribedAsFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.HiddenFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.HiddenFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.LabelAtFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.LabelAtFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.MultiLineFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.MultiLineFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.NamedFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.NamedFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.PromptStyleFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.PromptStyleFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.RenderedAdjustedFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.RenderedAdjustedFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.TypicalLengthFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.TypicalLengthFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.UnchangingFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.UnchangingFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.renderunchanged.UnchangingFacet;

public class PropertyLayoutFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public PropertyLayoutFacetFactory() {
        super(FeatureType.PROPERTIES_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod holder = this.facetHolderFrom(processMethodContext);
        Properties properties = this.metadataPropertiesFrom(processMethodContext);
        PropertyLayout propertyLayout = this.propertyLayoutAnnotationFrom(processMethodContext);
        this.processCssClass(holder, properties, propertyLayout);
        this.processDescribedAs(holder, properties, propertyLayout);
        this.processPromptStyle(holder, properties, propertyLayout);
        this.processHidden(holder, properties, propertyLayout);
        this.processLabelAt(holder, properties, propertyLayout);
        this.processMultiLine(holder, properties, propertyLayout);
        this.processNamed(holder, properties, propertyLayout);
        this.processRenderedAdjusted(holder, properties, propertyLayout);
        this.processTypicalLength(holder, properties, propertyLayout);
        this.processUnchanging(holder, properties, propertyLayout);
    }

    void processCssClass(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        CssClassFacet cssClassFacet = CssClassFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (cssClassFacet == null) {
            cssClassFacet = CssClassFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(cssClassFacet);
    }

    void processDescribedAs(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (describedAsFacet == null) {
            describedAsFacet = DescribedAsFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(describedAsFacet);
    }

    void processPromptStyle(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        PromptStyleFacet promptStyleFacet = PromptStyleFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (promptStyleFacet == null) {
            promptStyleFacet = PromptStyleFacetForPropertyLayoutAnnotation.create(propertyLayout, this.getConfiguration(), holder);
        }
        FacetUtil.addFacet(promptStyleFacet);
    }

    void processHidden(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        HiddenFacet hiddenFacet = HiddenFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (hiddenFacet == null) {
            hiddenFacet = HiddenFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(hiddenFacet);
    }

    void processLabelAt(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        LabelAtFacet labelAtFacet = LabelAtFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (labelAtFacet == null) {
            labelAtFacet = LabelAtFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(labelAtFacet);
    }

    void processMultiLine(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        MultiLineFacet multiLineFacet = MultiLineFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (multiLineFacet == null) {
            multiLineFacet = MultiLineFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(multiLineFacet);
    }

    void processNamed(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        NamedFacet namedFacet = NamedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (namedFacet == null) {
            namedFacet = NamedFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(namedFacet);
    }

    void processRenderedAdjusted(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        RenderedAdjustedFacet renderedAdjustedFacet = RenderedAdjustedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (renderedAdjustedFacet == null) {
            renderedAdjustedFacet = RenderedAdjustedFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(renderedAdjustedFacet);
    }

    void processTypicalLength(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        TypicalLengthFacet typicalLengthFacet = TypicalLengthFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (typicalLengthFacet == null) {
            typicalLengthFacet = TypicalLengthFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(typicalLengthFacet);
    }

    void processUnchanging(FacetHolder holder, Properties properties, PropertyLayout propertyLayout) {
        UnchangingFacet unchangingFacet = UnchangingFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (unchangingFacet == null) {
            unchangingFacet = UnchangingFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(unchangingFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Object holder = processMemberContext.getFacetHolder();
        Properties properties = this.metadataPropertiesFrom(processMemberContext);
        CssClassFacet cssClassFacet = CssClassFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(cssClassFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(hiddenFacet);
        LabelAtFacet labelAtFacet = LabelAtFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(labelAtFacet);
        MultiLineFacet multiLineFacet = MultiLineFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(multiLineFacet);
        NamedFacet namedFacet = NamedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(namedFacet);
        RenderedAdjustedFacet renderedAdjustedFacet = RenderedAdjustedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(renderedAdjustedFacet);
        TypicalLengthFacet typicalLengthFacet = TypicalLengthFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(typicalLengthFacet);
    }

    Properties metadataPropertiesFrom(FacetFactory.ProcessMethodContext processMethodContext) {
        Properties properties = processMethodContext.metadataProperties("propertyLayout");
        if (properties == null) {
            properties = processMethodContext.metadataProperties("layout");
        }
        return properties;
    }

    FacetedMethod facetHolderFrom(FacetFactory.ProcessMethodContext processMethodContext) {
        return (FacetedMethod)processMethodContext.getFacetHolder();
    }

    PropertyLayout propertyLayoutAnnotationFrom(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        return Annotations.getAnnotation(method, PropertyLayout.class);
    }

    Properties metadataPropertiesFrom(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Properties properties = processMemberContext.metadataProperties("propertyLayout");
        if (properties == null) {
            properties = processMemberContext.metadataProperties("layout");
        }
        return properties;
    }
}

