/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.propertylayout;

import java.util.Map;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleConfiguration;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetAsConfigured;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetFallBackToInline;

public class PromptStyleFacetForPropertyLayoutAnnotation
extends PromptStyleFacetAbstract {
    private final PromptStyle promptStyle;

    public PromptStyleFacetForPropertyLayoutAnnotation(PromptStyle promptStyle, FacetHolder holder) {
        super(holder);
        this.promptStyle = promptStyle;
    }

    public static PromptStyleFacet create(PropertyLayout propertyLayout, IsisConfiguration configuration, FacetHolder holder) {
        PromptStyle promptStyle;
        PromptStyle promptStyle2 = promptStyle = propertyLayout != null ? propertyLayout.promptStyle() : null;
        if (promptStyle == null) {
            if (holder.containsDoOpFacet(PromptStyleFacet.class)) {
                return null;
            }
            return new PromptStyleFacetFallBackToInline(holder);
        }
        switch (promptStyle) {
            case DIALOG: 
            case INLINE: {
                return new PromptStyleFacetForPropertyLayoutAnnotation(promptStyle, holder);
            }
            case INLINE_AS_IF_EDIT: {
                return new PromptStyleFacetForPropertyLayoutAnnotation(PromptStyle.INLINE, holder);
            }
            case AS_CONFIGURED: {
                if (holder.containsDoOpFacet(PromptStyleFacet.class)) {
                    return null;
                }
                promptStyle = PromptStyleConfiguration.parse(configuration);
                return new PromptStyleFacetAsConfigured(promptStyle, holder);
            }
        }
        if (holder.containsDoOpFacet(PromptStyleFacet.class)) {
            return null;
        }
        promptStyle = PromptStyleConfiguration.parse(configuration);
        return new PromptStyleFacetAsConfigured(promptStyle, holder);
    }

    @Override
    public PromptStyle value() {
        return this.promptStyle;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("promptStyle", this.promptStyle);
    }
}

