/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.regex;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacetAbstract;

public class RegExFacetForPropertyAnnotation
extends RegExFacetAbstract {
    private final Pattern pattern;

    public static RegExFacet create(Property annotation, Class<?> returnType, FacetHolder holder) {
        if (annotation == null) {
            return null;
        }
        if (!Annotations.isString(returnType)) {
            return null;
        }
        String pattern = annotation.regexPattern();
        if (Strings.isNullOrEmpty((String)pattern)) {
            return null;
        }
        String replacement = annotation.regexPatternReplacement();
        int patternFlags = annotation.regexPatternFlags();
        return new RegExFacetForPropertyAnnotation(pattern, patternFlags, holder, replacement);
    }

    private RegExFacetForPropertyAnnotation(String pattern, int patternFlags, FacetHolder holder, String replacement) {
        super(pattern, "", (patternFlags & 2) == 2, holder, replacement);
        this.pattern = Pattern.compile(pattern, patternFlags);
    }

    @Override
    public String format(String text) {
        return text;
    }

    @Override
    public boolean doesNotMatch(String text) {
        if (text == null) {
            return true;
        }
        return !this.pattern.matcher(text).matches();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("pattern", this.pattern);
    }
}

