/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.command;

import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.annotation.CommandExecuteIn;
import org.apache.isis.applib.annotation.CommandPersistence;
import org.apache.isis.applib.annotation.CommandReification;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.command.CommandFacetForPropertyAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.properties.property.command.CommandPropertiesConfiguration;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class CommandFacetForPropertyAnnotation
extends CommandFacetAbstract {
    public static CommandFacet create(Property property, IsisConfiguration configuration, FacetHolder holder, ServicesInjector servicesInjector) {
        CommandReification commandReification = property != null ? property.command() : CommandReification.AS_CONFIGURED;
        CommandPersistence commandPersistence = property != null ? property.commandPersistence() : CommandPersistence.PERSISTED;
        CommandExecuteIn commandExecuteIn = property != null ? property.commandExecuteIn() : CommandExecuteIn.FOREGROUND;
        Class processorClass = property != null ? property.commandDtoProcessor() : null;
        CommandDtoProcessor processor = CommandFacetForPropertyAnnotation.newProcessorElseNull(processorClass);
        if (processor != null) {
            commandReification = CommandReification.ENABLED;
        }
        Command.Persistence persistence = CommandPersistence.from((CommandPersistence)commandPersistence);
        Command.ExecuteIn executeIn = CommandExecuteIn.from((CommandExecuteIn)commandExecuteIn);
        switch (commandReification) {
            case AS_CONFIGURED: {
                CommandPropertiesConfiguration setting = CommandPropertiesConfiguration.parse(configuration);
                switch (setting) {
                    case NONE: {
                        return null;
                    }
                }
                return property != null ? new CommandFacetForPropertyAnnotationAsConfigured(persistence, executeIn, CommandFacetAbstract.Enablement.ENABLED, holder, servicesInjector) : CommandFacetFromConfiguration.create(holder, servicesInjector);
            }
            case DISABLED: {
                return null;
            }
            case ENABLED: {
                return new CommandFacetForPropertyAnnotation(persistence, executeIn, CommandFacetAbstract.Enablement.ENABLED, holder, processor, servicesInjector);
            }
        }
        return null;
    }

    CommandFacetForPropertyAnnotation(Command.Persistence persistence, Command.ExecuteIn executeIn, CommandFacetAbstract.Enablement enablement, FacetHolder holder, CommandDtoProcessor processor, ServicesInjector servicesInjector) {
        super(persistence, executeIn, enablement, processor, holder, servicesInjector);
    }
}

