/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.autocomplete.method;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.MinLengthUtil;
import org.apache.isis.core.metamodel.facets.properties.autocomplete.PropertyAutoCompleteFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class PropertyAutoCompleteFacetMethod
extends PropertyAutoCompleteFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final int minLength;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final AdapterManager adapterManager;
    private final DeploymentCategory deploymentCategory;
    private SpecificationLoader specificationLoader;

    public PropertyAutoCompleteFacetMethod(Method method, Class<?> choicesClass, FacetHolder holder, DeploymentCategory deploymentCategory, SpecificationLoader specificationLoader, AuthenticationSessionProvider authenticationSessionProvider, AdapterManager adapterManager) {
        super(holder);
        this.method = method;
        this.choicesClass = choicesClass;
        this.deploymentCategory = deploymentCategory;
        this.specificationLoader = specificationLoader;
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.adapterManager = adapterManager;
        this.minLength = MinLengthUtil.determineMinLength(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public Object[] autoComplete(ObjectAdapter owningAdapter, String searchArg, InteractionInitiatedBy interactionInitiatedBy) {
        AuthenticationSession authenticationSession = this.getAuthenticationSession();
        DeploymentCategory deploymentCategory = this.getDeploymentCategory();
        Object collectionOrArray = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter, searchArg);
        if (collectionOrArray == null) {
            return null;
        }
        ObjectAdapter collectionAdapter = this.getAdapterManager().adapterFor(collectionOrArray);
        FacetedMethod facetedMethod = (FacetedMethod)this.getFacetHolder();
        Class<?> propertyType = facetedMethod.getType();
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, interactionInitiatedBy);
        ArrayList filteredObjects = Lists.newArrayList((Iterable)Iterables.transform(visibleAdapters, ObjectAdapter.Functions.getObject()));
        ObjectSpecification propertySpec = this.getSpecification(propertyType);
        return CollectionUtils.getCollectionAsObjectArray(filteredObjects, propertySpec, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    protected ObjectSpecification getSpecification(Class<?> type) {
        return type != null ? this.getSpecificationLoader().loadSpecification(type) : null;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    protected DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
        attributeMap.put("choicesType", this.choicesClass);
        attributeMap.put("minLength", this.minLength);
    }
}

