/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.accessor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class PropertyAccessorFacetViaAccessor
extends PropertyOrCollectionAccessorFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public PropertyAccessorFacetViaAccessor(ObjectSpecification typeSpec, Method method, FacetHolder holder, DeploymentCategory deploymentCategory, IsisConfiguration isisConfiguration, SpecificationLoader specificationLoader, AuthenticationSessionProvider authenticationSessionProvider, AdapterManager adapterManager) {
        super(typeSpec, holder, deploymentCategory, isisConfiguration, specificationLoader, authenticationSessionProvider, adapterManager);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.ACCESSOR;
    }

    @Override
    public Object getProperty(ObjectAdapter owningAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter referencedAdapter;
        boolean visible;
        Object referencedObject = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (referencedObject == null) {
            return null;
        }
        boolean filterForVisibility = this.getConfiguration().getBoolean("isis.reflector.facet.filterVisibility", true);
        if (filterForVisibility && !(visible = ObjectAdapter.Util.isVisible(referencedAdapter = this.getAdapterManager().adapterFor(referencedObject), interactionInitiatedBy))) {
            return null;
        }
        return referencedObject;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

