/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.parameter.regex;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacetAbstract;

public class RegExFacetForParameterAnnotation
extends RegExFacetAbstract {
    private final Pattern pattern;

    public static RegExFacet create(Parameter parameter, Class<?> parameterType, FacetHolder holder) {
        if (parameter == null) {
            return null;
        }
        if (!Annotations.isString(parameterType)) {
            return null;
        }
        String pattern = parameter.regexPattern();
        if (Strings.isNullOrEmpty((String)pattern)) {
            return null;
        }
        String replacement = parameter.regexPatternReplacement();
        int patternFlags = parameter.regexPatternFlags();
        return new RegExFacetForParameterAnnotation(pattern, patternFlags, holder, replacement);
    }

    private RegExFacetForParameterAnnotation(String pattern, int patternFlags, FacetHolder holder, String replacement) {
        super(pattern, "", false, holder, replacement);
        this.pattern = Pattern.compile(pattern, patternFlags);
    }

    @Override
    public String format(String text) {
        return text;
    }

    @Override
    public boolean doesNotMatch(String text) {
        if (text == null) {
            return true;
        }
        return !this.pattern.matcher(text).matches();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("pattern", this.pattern);
    }
}

